/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.utils;

import java.net.InetSocketAddress;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.opennms.smoketest.containers.KarafContainer;
import org.opennms.smoketest.utils.DevDebugUtils;
import org.opennms.smoketest.utils.KarafShell;
import org.opennms.smoketest.utils.SshClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafShellUtils {
    private static final Logger LOG = LoggerFactory.getLogger(KarafShellUtils.class);

    public static boolean isSuccessMsg(String s) {
        return s.startsWith("=> Everything is awesome");
    }

    public static boolean isFailureMessage(String s) {
        return s.startsWith("=> Oh no, something is wrong");
    }

    public static boolean isEndMessage(String s) {
        return KarafShellUtils.isSuccessMsg(s) || KarafShellUtils.isFailureMessage(s) || s.contains("Command not found");
    }

    public static void awaitHealthCheckSucceeded(KarafContainer container) {
        InetSocketAddress addr = container.getSshAddress();
        Objects.requireNonNull(addr);
        Awaitility.await((String)(container.getDockerImageName() + " health check")).atMost(3L, TimeUnit.MINUTES).failFast("container is no longer running", () -> !container.isRunning()).pollDelay(Duration.ZERO).pollInterval(5L, TimeUnit.SECONDS).ignoreExceptions().untilAsserted(() -> KarafShellUtils.testHealthCheckSucceeded(addr));
    }

    public static void testHealthCheckSucceeded(InetSocketAddress sshAddr) throws Exception {
        HealthCheckResult healthCheckResult = KarafShellUtils.executeHealthCheck(sshAddr);
        MatcherAssert.assertThat((String)("health check result: " + healthCheckResult + "\nMost recent exception from karaf:\n" + (String)new KarafShell(sshAddr).run("log:exception-display").getLeft()), (boolean)healthCheckResult.isSuccess());
    }

    public static HealthCheckResult executeHealthCheck(InetSocketAddress sshAddr) throws Exception {
        return KarafShellUtils.withKarafShell(sshAddr, Duration.ofMinutes(2L), streams -> {
            Duration healthCheckTimeout = Duration.ofSeconds(5L);
            streams.stdin.println("opennms:health-check -t " + healthCheckTimeout.toMillis());
            Awaitility.await().atMost(healthCheckTimeout.plus(Duration.ofSeconds(5L))).until(() -> streams.stdout.getLines().stream().anyMatch(KarafShellUtils::isEndMessage));
            return new HealthCheckResult(streams.stdout.getLines(), streams.stderr.getLines());
        });
    }

    public static void saveCoverage(KarafContainer container, String prefix, String type) {
        if (!container.isRunning()) {
            LOG.warn("Container [{}] isn't running, cannot save coverage data", (Object)container.getDockerImageName());
            return;
        }
        try {
            LOG.info("Triggering code coverage data file dump...");
            KarafShellUtils.triggerCoverageDump(container, "/tmp/jacoco.exec");
            LOG.info("Gathering coverage files...");
            DevDebugUtils.copyLogs(container, Paths.get("target", "coverage", prefix, type), Paths.get("/tmp", new String[0]), Arrays.asList("jacoco.exec"));
        }
        catch (Exception e) {
            LOG.error("I been hacked. all my dumps gone. this just failed please help me", (Throwable)e);
        }
    }

    protected static void triggerCoverageDump(KarafContainer container, String outputFile) throws Exception {
        Objects.requireNonNull(container);
        try (SshClient sshClient = (SshClient)Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(Duration.ofMinutes(1L)).ignoreExceptions().until(() -> {
            SshClient client = container.ssh();
            client.openShell();
            return client;
        }, Matchers.notNullValue());){
            SshClient.Streams streams = sshClient.getStreams();
            streams.stdin.println("jacoco:dump " + (outputFile == null ? "jacoco.exec" : outputFile));
            Awaitility.await().atMost(Duration.ofMinutes(1L)).until(() -> streams.stdout.getLines().stream().anyMatch(line -> line.contains("Wrote") && line.contains("bytes")));
            streams.stdin.println("logout");
            streams.stdout.interrupt();
            streams.stderr.interrupt();
        }
    }

    /*
     * Loose catch block
     */
    public static <T> T withKarafShell(InetSocketAddress sshAddr, Duration waitForShellTimeout, Function<SshClient.Streams, T> withStreams) throws Exception {
        Objects.requireNonNull(sshAddr);
        try (SshClient sshClient = (SshClient)Awaitility.await().pollDelay(5L, TimeUnit.SECONDS).atMost(waitForShellTimeout).ignoreExceptions().until(() -> {
            SshClient client = new SshClient(sshAddr, "admin", "admin");
            client.openShell();
            return client;
        }, Matchers.notNullValue());){
            T t;
            SshClient.Streams streams = sshClient.getStreams();
            try {
                t = withStreams.apply(streams);
            }
            catch (Throwable t2) {
                throw new RuntimeException("test function raised an exception\nstdout:\n" + streams.stdout.getLines().stream().collect(Collectors.joining("\n")) + "\nstderr:\n" + streams.stderr.getLines().stream().collect(Collectors.joining("\n")), t2);
            }
            finally {
                try {
                    streams.stdin.println("logout");
                    streams.stdout.interrupt();
                    streams.stderr.interrupt();
                }
                catch (Throwable t3) {
                    LOG.error("Karaf shell cleanup failed", t3);
                }
            }
            return t;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static class HealthCheckResult {
        public final List<String> stdout;
        public final List<String> stderr;

        public HealthCheckResult(List<String> stdout, List<String> stderr) {
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public boolean isSuccess() {
            return this.stdout.stream().anyMatch(KarafShellUtils::isSuccessMsg);
        }

        public String toString() {
            return "HealthCheckResult{\n===stdout===\n" + this.stdout.stream().collect(Collectors.joining("\n")) + "\n===stderr===\n" + this.stderr.stream().collect(Collectors.joining("\n")) + "}";
        }
    }
}

