/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.smoketest.selenium;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExpectedConditions {
    private static final Logger LOG = LoggerFactory.getLogger(ExpectedConditions.class);

    private ExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> pageContainsText(String text) {
        LOG.debug("pageContainsText: {}", (Object)text);
        String escapedText = text.replace("'", "\\'");
        return driver -> {
            String xpathExpression = "//*[contains(., '" + escapedText + "')]";
            LOG.debug("XPath expression: {}", (Object)xpathExpression);
            try {
                WebElement element = driver.findElement(By.xpath((String)xpathExpression));
                return element != null;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        };
    }
}

