/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.enlinkd;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.enlinkd.model.BridgeElement;
import org.opennms.netmgt.enlinkd.model.CdpElement;
import org.opennms.netmgt.enlinkd.model.CdpLink;
import org.opennms.netmgt.enlinkd.model.IpNetToMedia;
import org.opennms.netmgt.enlinkd.model.IsIsElement;
import org.opennms.netmgt.enlinkd.model.IsIsLink;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.enlinkd.model.OspfElement;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.enlinkd.persistence.api.BridgeElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.CdpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.CdpLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.IpNetToMediaDao;
import org.opennms.netmgt.enlinkd.persistence.api.IsIsElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.IsIsLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.LldpElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.LldpLinkDao;
import org.opennms.netmgt.enlinkd.persistence.api.OspfElementDao;
import org.opennms.netmgt.enlinkd.persistence.api.OspfLinkDao;
import org.opennms.netmgt.enlinkd.service.api.BridgePort;
import org.opennms.netmgt.enlinkd.service.api.BridgeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.SharedSegment;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.web.api.Util;
import org.opennms.web.enlinkd.BridgeElementNode;
import org.opennms.web.enlinkd.BridgeLinkNode;
import org.opennms.web.enlinkd.BridgeLinkRemoteNode;
import org.opennms.web.enlinkd.CdpElementNode;
import org.opennms.web.enlinkd.CdpLinkNode;
import org.opennms.web.enlinkd.EnLinkdElementFactoryInterface;
import org.opennms.web.enlinkd.IsisElementNode;
import org.opennms.web.enlinkd.IsisLinkNode;
import org.opennms.web.enlinkd.LldpElementNode;
import org.opennms.web.enlinkd.LldpLinkNode;
import org.opennms.web.enlinkd.OspfElementNode;
import org.opennms.web.enlinkd.OspfLinkNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Transactional(readOnly=true)
public class EnLinkdElementFactory
implements InitializingBean,
EnLinkdElementFactoryInterface {
    private static final Logger LOG = LoggerFactory.getLogger(EnLinkdElementFactory.class);
    @Autowired
    private OspfElementDao m_ospfElementDao;
    @Autowired
    private OspfLinkDao m_ospfLinkDao;
    @Autowired
    private LldpElementDao m_lldpElementDao;
    @Autowired
    private LldpLinkDao m_lldpLinkDao;
    @Autowired
    private CdpElementDao m_cdpElementDao;
    @Autowired
    private CdpLinkDao m_cdpLinkDao;
    @Autowired
    private BridgeElementDao m_bridgeElementDao;
    @Autowired
    private BridgeTopologyService m_bridgeTopologyService;
    @Autowired
    private IpNetToMediaDao m_ipNetToMediaDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private IsIsElementDao m_isisElementDao;
    @Autowired
    private IsIsLinkDao m_isisLinkDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    public static EnLinkdElementFactoryInterface getInstance(ServletContext servletContext) {
        return EnLinkdElementFactory.getInstance((ApplicationContext)WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext));
    }

    public static EnLinkdElementFactoryInterface getInstance(ApplicationContext appContext) {
        return (EnLinkdElementFactoryInterface)appContext.getBean(EnLinkdElementFactoryInterface.class);
    }

    @Override
    public OspfElementNode getOspfElement(int nodeId) {
        return this.convertFromModel((OspfElement)this.m_ospfElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private OspfElementNode convertFromModel(OspfElement ospf) {
        if (ospf == null) {
            return null;
        }
        OspfElementNode ospfNode = new OspfElementNode();
        ospfNode.setOspfRouterId(InetAddressUtils.str((InetAddress)ospf.getOspfRouterId()));
        ospfNode.setOspfVersionNumber(ospf.getOspfVersionNumber());
        ospfNode.setOspfAdminStat(OspfElement.Status.getTypeString((Integer)ospf.getOspfAdminStat().getValue()));
        ospfNode.setOspfCreateTime(Util.formatDateToUIString(ospf.getOspfNodeCreateTime()));
        ospfNode.setOspfLastPollTime(Util.formatDateToUIString(ospf.getOspfNodeLastPollTime()));
        return ospfNode;
    }

    @Override
    public List<OspfLinkNode> getOspfLinks(int nodeId) {
        return this.getOspfLinks(nodeId, new SnmpInterfaceCache());
    }

    private List<OspfLinkNode> getOspfLinks(int nodeId, SnmpInterfaceCache snmpInterfaceCache) {
        ArrayList<OspfLinkNode> nodelinks = new ArrayList<OspfLinkNode>();
        UniqueMapCache<InetAddress, OspfElement> remRouterIdToOspfElement = EnLinkdElementFactory.uniqueMapCache(() -> this.m_ospfElementDao.findByRouterIdOfRelatedOspfLink(nodeId), OspfElement::getOspfRouterId, OspfElement::getId);
        for (OspfLink link : this.m_ospfLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link, snmpInterfaceCache, remRouterIdToOspfElement));
        }
        return nodelinks;
    }

    public OspfLinkNode create(int nodeid, OspfLink link, SnmpInterfaceCache snmpInterfaceCache) {
        OspfLinkNode linknode = new OspfLinkNode();
        OnmsSnmpInterface snmpiface = null;
        String ipaddr = InetAddressUtils.str((InetAddress)link.getOspfIpAddr());
        if (link.getOspfIfIndex() != null) {
            snmpiface = (OnmsSnmpInterface)snmpInterfaceCache.get(nodeid, link.getOspfIfIndex());
        } else if (link.getOspfAddressLessIndex() != null && link.getOspfAddressLessIndex() > 0) {
            snmpiface = (OnmsSnmpInterface)snmpInterfaceCache.get(nodeid, link.getOspfAddressLessIndex());
        }
        if (snmpiface != null) {
            if (link.getOspfAddressLessIndex() != null && link.getOspfAddressLessIndex() > 0) {
                linknode.setOspfLocalPort(this.getPortString(snmpiface, "address less", null));
            } else {
                linknode.setOspfLocalPort(this.getPortString(snmpiface, "ip", ipaddr));
            }
            linknode.setOspfLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, snmpiface.getIfIndex()));
        } else if (link.getOspfAddressLessIndex() != null && link.getOspfAddressLessIndex() > 0) {
            linknode.setOspfLocalPort(this.getPortString(link.getOspfAddressLessIndex(), "address less", null));
        } else if (link.getOspfIfIndex() != null && ipaddr != null) {
            linknode.setOspfLocalPort(this.getPortString(link.getOspfIfIndex(), "ip", ipaddr));
            linknode.setOspfLocalPortUrl(this.getIpInterfaceUrl(nodeid, ipaddr));
        } else if (ipaddr != null) {
            linknode.setOspfLocalPort(this.getIdString("ip", ipaddr));
            linknode.setOspfLocalPortUrl(this.getIpInterfaceUrl(nodeid, ipaddr));
        }
        if (link.getOspfIpMask() != null) {
            linknode.setOspfLinkInfo(this.getIdString("mask", InetAddressUtils.str((InetAddress)link.getOspfIpMask())));
        } else {
            linknode.setOspfLinkInfo(this.getIdString("No mask", null));
        }
        linknode.setOspfLinkCreateTime(Util.formatDateToUIString(link.getOspfLinkCreateTime()));
        linknode.setOspfLinkLastPollTime(Util.formatDateToUIString(link.getOspfLinkLastPollTime()));
        return linknode;
    }

    public OspfLinkNode convertFromModel(int nodeid, OspfLink link, SnmpInterfaceCache snmpInterfaceCache, UniqueMapCache<InetAddress, OspfElement> remRouterIdToOspfElement) {
        OspfLinkNode linknode = this.create(nodeid, link, snmpInterfaceCache);
        Integer remNodeid = null;
        String remNodeLabel = null;
        OspfElement remOspfElement = remRouterIdToOspfElement.get(link.getOspfRemRouterId());
        if (remOspfElement != null) {
            remNodeid = remOspfElement.getNode().getId();
            remNodeLabel = remOspfElement.getNode().getLabel();
        }
        if (remNodeid != null) {
            linknode.setOspfRemRouterId(this.getHostString(remNodeLabel, "router id", InetAddressUtils.str((InetAddress)link.getOspfRemRouterId())));
            linknode.setOspfRemRouterUrl(this.getNodeUrl(remNodeid));
        } else {
            linknode.setOspfRemRouterId(this.getIdString("router id", InetAddressUtils.str((InetAddress)link.getOspfRemRouterId())));
        }
        String remipaddr = InetAddressUtils.str((InetAddress)link.getOspfRemIpAddr());
        OnmsSnmpInterface remsnmpiface = null;
        if (remNodeid != null) {
            if (link.getOspfRemAddressLessIndex() != null && link.getOspfRemAddressLessIndex() > 0) {
                remsnmpiface = (OnmsSnmpInterface)snmpInterfaceCache.get(remNodeid, link.getOspfAddressLessIndex());
            } else {
                OnmsIpInterface remipiface = this.m_ipInterfaceDao.findByNodeIdAndIpAddress(remNodeid, remipaddr);
                if (remipiface != null) {
                    remsnmpiface = remipiface.getSnmpInterface();
                }
            }
        }
        if (remsnmpiface != null) {
            if (link.getOspfRemAddressLessIndex() != null && link.getOspfRemAddressLessIndex() > 0) {
                linknode.setOspfRemPort(this.getPortString(remsnmpiface, "address less", null));
            } else {
                linknode.setOspfRemPort(this.getPortString(remsnmpiface, "ip", remipaddr));
            }
            linknode.setOspfRemPortUrl(this.getSnmpInterfaceUrl(remNodeid, remsnmpiface.getIfIndex()));
        } else if (link.getOspfAddressLessIndex() != null && link.getOspfAddressLessIndex() > 0) {
            linknode.setOspfRemPort(this.getPortString(link.getOspfRemAddressLessIndex(), "address less", null));
        } else if (remipaddr != null) {
            linknode.setOspfRemPort(this.getIdString("ip", remipaddr));
            if (remNodeid != null) {
                linknode.setOspfRemPortUrl(this.getIpInterfaceUrl(remNodeid, remipaddr));
            }
        }
        return linknode;
    }

    @Override
    public CdpElementNode getCdpElement(int nodeId) {
        return this.convertFromModel((CdpElement)this.m_cdpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private CdpElementNode convertFromModel(CdpElement cdp) {
        if (cdp == null) {
            return null;
        }
        CdpElementNode cdpNode = new CdpElementNode();
        cdpNode.setCdpGlobalRun(OspfElement.TruthValue.getTypeString((Integer)cdp.getCdpGlobalRun().getValue()));
        cdpNode.setCdpGlobalDeviceId(cdp.getCdpGlobalDeviceId());
        if (cdp.getCdpGlobalDeviceIdFormat() != null) {
            cdpNode.setCdpGlobalDeviceIdFormat(CdpElement.CdpGlobalDeviceIdFormat.getTypeString((Integer)cdp.getCdpGlobalDeviceIdFormat().getValue()));
        } else {
            cdpNode.setCdpGlobalDeviceIdFormat("&nbsp");
        }
        cdpNode.setCdpCreateTime(Util.formatDateToUIString(cdp.getCdpNodeCreateTime()));
        cdpNode.setCdpLastPollTime(Util.formatDateToUIString(cdp.getCdpNodeLastPollTime()));
        return cdpNode;
    }

    @Override
    public List<CdpLinkNode> getCdpLinks(int nodeId) {
        return this.getCdpLinks(nodeId, new SnmpInterfaceCache());
    }

    private List<CdpLinkNode> getCdpLinks(int nodeId, SnmpInterfaceCache snmpInterfaceCache) {
        ArrayList<CdpLinkNode> nodelinks = new ArrayList<CdpLinkNode>();
        UniqueMapCache<String, CdpElement> deviceIdToCdpElement = EnLinkdElementFactory.uniqueMapCache(() -> this.m_cdpElementDao.findByCacheDeviceIdOfCdpLinksOfNode(nodeId), CdpElement::getCdpGlobalDeviceId, CdpElement::getId);
        for (CdpLink link : this.m_cdpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link, snmpInterfaceCache, deviceIdToCdpElement));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    public CdpLinkNode create(int nodeid, CdpLink link, SnmpInterfaceCache snmpInterfaceCache) {
        CdpLinkNode linknode = new CdpLinkNode();
        linknode.setCdpLocalPort(this.getPortString(link.getCdpInterfaceName(), link.getCdpCacheIfIndex(), null, null));
        OnmsSnmpInterface snmpiface = (OnmsSnmpInterface)snmpInterfaceCache.get(nodeid, link.getCdpCacheIfIndex());
        if (snmpiface != null) {
            Set ipifaces = snmpiface.getIpInterfaces();
            if (ipifaces.isEmpty() || ipifaces.size() > 1) {
                linknode.setCdpLocalPort(this.getPortString(snmpiface, null, null));
            } else {
                linknode.setCdpLocalPort(this.getPortString(snmpiface, "ip", InetAddressUtils.str((InetAddress)((OnmsIpInterface)ipifaces.iterator().next()).getIpAddress())));
            }
            linknode.setCdpLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getCdpCacheIfIndex()));
        }
        linknode.setCdpCreateTime(Util.formatDateToUIString(link.getCdpLinkCreateTime()));
        linknode.setCdpLastPollTime(Util.formatDateToUIString(link.getCdpLinkLastPollTime()));
        linknode.setCdpCachePlatform(link.getCdpCacheDevicePlatform() + " -> " + link.getCdpCacheVersion());
        return linknode;
    }

    public CdpLinkNode convertFromModel(int nodeid, CdpLink link, SnmpInterfaceCache snmpInterfaceCache, UniqueMapCache<String, CdpElement> deviceIdToCdpElement) {
        CdpLinkNode linknode = this.create(nodeid, link, snmpInterfaceCache);
        linknode.setCdpCacheDevice(link.getCdpCacheDeviceId());
        linknode.setCdpCacheDevicePort(this.getPortString(link.getCdpCacheDevicePort(), null, CdpLink.CiscoNetworkProtocolType.getTypeString((Integer)link.getCdpCacheAddressType().getValue()), link.getCdpCacheAddress()));
        CdpElement cdpCacheElement = deviceIdToCdpElement.get(link.getCdpCacheDeviceId());
        if (cdpCacheElement != null) {
            linknode.setCdpCacheDevice(this.getHostString(cdpCacheElement.getNode().getLabel(), "Cisco Device Id", link.getCdpCacheDeviceId()));
            linknode.setCdpCacheDeviceUrl(this.getNodeUrl(cdpCacheElement.getNode().getId()));
            OnmsSnmpInterface cdpcachesnmp = this.getFromCdpCacheDevicePort(cdpCacheElement.getNode().getId(), link.getCdpCacheDevicePort(), snmpInterfaceCache);
            if (cdpcachesnmp != null) {
                linknode.setCdpCacheDevicePort(this.getPortString(cdpcachesnmp, CdpLink.CiscoNetworkProtocolType.getTypeString((Integer)link.getCdpCacheAddressType().getValue()), link.getCdpCacheAddress()));
                linknode.setCdpCacheDevicePortUrl(this.getSnmpInterfaceUrl(cdpCacheElement.getNode().getId(), cdpcachesnmp.getIfIndex()));
            }
        }
        return linknode;
    }

    @Override
    public LldpElementNode getLldpElement(int nodeId) {
        return this.convertFromModel((LldpElement)this.m_lldpElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private LldpElementNode convertFromModel(LldpElement lldp) {
        if (lldp == null) {
            return null;
        }
        LldpElementNode lldpNode = new LldpElementNode();
        lldpNode.setLldpChassisId(this.getIdString(LldpUtils.LldpChassisIdSubType.getTypeString((Integer)lldp.getLldpChassisIdSubType().getValue()), lldp.getLldpChassisId()));
        lldpNode.setLldpSysName(lldp.getLldpSysname());
        lldpNode.setLldpCreateTime(Util.formatDateToUIString(lldp.getLldpNodeCreateTime()));
        lldpNode.setLldpLastPollTime(Util.formatDateToUIString(lldp.getLldpNodeLastPollTime()));
        return lldpNode;
    }

    @Override
    public List<LldpLinkNode> getLldpLinks(int nodeId) {
        ArrayList<LldpLinkNode> nodelinks = new ArrayList<LldpLinkNode>();
        UniqueMapCache<Pair<String, LldpUtils.LldpChassisIdSubType>, LldpElement> chassisToLldpElement = EnLinkdElementFactory.uniqueMapCache(() -> this.m_lldpElementDao.findByChassisOfLldpLinksOfNode(nodeId), e -> Pair.of((Object)e.getLldpChassisId(), (Object)e.getLldpChassisIdSubType()), LldpElement::getId);
        UniqueMapCache<String, OnmsNode> sysNameToNode = EnLinkdElementFactory.uniqueMapCache(() -> this.m_nodeDao.findBySysNameOfLldpLinksOfNode(nodeId), OnmsNode::getSysName, OnmsNode::getId);
        for (LldpLink link : this.m_lldpLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link, chassisToLldpElement, sysNameToNode));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    private LldpLinkNode create(int nodeid, LldpLink link) {
        LldpLinkNode linknode = new LldpLinkNode();
        linknode.setLldpLocalPort(this.getPortString(link.getLldpPortDescr(), link.getLldpPortIfindex(), LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpPortIdSubType().getValue()), link.getLldpPortId()));
        linknode.setLldpLocalPortUrl(this.getSnmpInterfaceUrl(nodeid, link.getLldpPortIfindex()));
        linknode.setLldpRemInfo(link.getLldpRemSysname());
        linknode.setLldpCreateTime(Util.formatDateToUIString(link.getLldpLinkCreateTime()));
        linknode.setLldpLastPollTime(Util.formatDateToUIString(link.getLldpLinkLastPollTime()));
        return linknode;
    }

    private LldpLinkNode convertFromModel(int nodeid, LldpLink link, UniqueMapCache<Pair<String, LldpUtils.LldpChassisIdSubType>, LldpElement> chassisToLldpElements, UniqueMapCache<String, OnmsNode> sysNameToNode) {
        LldpLinkNode linknode = this.create(nodeid, link);
        linknode.setLldpRemChassisId(this.getIdString(LldpUtils.LldpChassisIdSubType.getTypeString((Integer)link.getLldpRemChassisIdSubType().getValue()), link.getLldpRemChassisId()));
        linknode.setLldpRemPort(this.getPortString(link.getLldpRemPortDescr(), null, LldpUtils.LldpPortIdSubType.getTypeString((Integer)link.getLldpRemPortIdSubType().getValue()), link.getLldpRemPortId()));
        LldpElement lldpElement = chassisToLldpElements.get((Pair<String, LldpUtils.LldpChassisIdSubType>)Pair.of((Object)link.getLldpRemChassisId(), (Object)link.getLldpRemChassisIdSubType()));
        OnmsNode remNode = lldpElement != null ? lldpElement.getNode() : sysNameToNode.get(link.getLldpRemSysname());
        if (remNode != null) {
            linknode.setLldpRemChassisId(this.getHostString(remNode.getLabel(), LldpUtils.LldpChassisIdSubType.getTypeString((Integer)link.getLldpRemChassisIdSubType().getValue()), link.getLldpRemChassisId()));
            linknode.setLldpRemChassisIdUrl(this.getNodeUrl(remNode.getId()));
            if (link.getLldpRemPortIdSubType() == LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_LOCAL) {
                try {
                    Integer remIfIndex = SystemProperties.getInteger((String)link.getLldpRemPortId());
                    linknode.setLldpRemPortUrl(this.getSnmpInterfaceUrl((int)remNode.getId(), remIfIndex));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return linknode;
    }

    @Override
    public IsisElementNode getIsisElement(int nodeId) {
        return this.convertFromModel((IsIsElement)this.m_isisElementDao.findByNodeId(Integer.valueOf(nodeId)));
    }

    private IsisElementNode convertFromModel(IsIsElement isis) {
        if (isis == null) {
            return null;
        }
        IsisElementNode isisNode = new IsisElementNode();
        isisNode.setIsisSysID(isis.getIsisSysID());
        isisNode.setIsisSysAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)isis.getIsisSysAdminState().getValue()));
        isisNode.setIsisCreateTime(Util.formatDateToUIString(isis.getIsisNodeCreateTime()));
        isisNode.setIsisLastPollTime(Util.formatDateToUIString(isis.getIsisNodeLastPollTime()));
        return isisNode;
    }

    @Override
    public List<IsisLinkNode> getIsisLinks(int nodeId) {
        return this.getIsisLinks(nodeId, new SnmpInterfaceCache());
    }

    private List<IsisLinkNode> getIsisLinks(int nodeId, SnmpInterfaceCache snmpInterfaceCache) {
        ArrayList<IsisLinkNode> nodelinks = new ArrayList<IsisLinkNode>();
        UniqueMapCache<String, IsIsElement> sysIdToElement = EnLinkdElementFactory.uniqueMapCache(() -> this.m_isisElementDao.findBySysIdOfIsIsLinksOfNode(nodeId), IsIsElement::getIsisSysID, IsIsElement::getId);
        UniqueMapCache<Pair<Integer, Integer>, IsIsLink> adjAndCircIdxToLink = EnLinkdElementFactory.uniqueMapCache(() -> this.m_isisLinkDao.findBySysIdAndAdjAndCircIndex(nodeId), l -> Pair.of((Object)l.getIsisISAdjIndex(), (Object)l.getIsisCircIndex()), IsIsLink::getId);
        UniqueMapCache<String, OnmsSnmpInterface> adjNeighSnpaAddressToInterface = EnLinkdElementFactory.uniqueMapCache(() -> this.m_snmpInterfaceDao.findBySnpaAddressOfRelatedIsIsLink(nodeId), OnmsSnmpInterface::getPhysAddr, OnmsSnmpInterface::getId);
        for (IsIsLink link : this.m_isisLinkDao.findByNodeId(Integer.valueOf(nodeId))) {
            nodelinks.add(this.convertFromModel(nodeId, link, snmpInterfaceCache, sysIdToElement, adjAndCircIdxToLink, adjNeighSnpaAddressToInterface));
        }
        Collections.sort(nodelinks);
        return nodelinks;
    }

    private IsisLinkNode convertFromModel(int nodeid, IsIsLink link, SnmpInterfaceCache snmpInterfaceCache, UniqueMapCache<String, IsIsElement> sysIdToElement, UniqueMapCache<Pair<Integer, Integer>, IsIsLink> adjAndCircIdxToLink, UniqueMapCache<String, OnmsSnmpInterface> adjNeighSnpaAddressToInterface) {
        IsIsLink adjLink;
        IsisLinkNode linknode = new IsisLinkNode();
        linknode.setIsisCircIfIndex(link.getIsisCircIfIndex());
        linknode.setIsisCircAdminState(IsIsElement.IsisAdminState.getTypeString((Integer)link.getIsisCircAdminState().getValue()));
        IsIsElement isiselement = sysIdToElement.get(link.getIsisISAdjNeighSysID());
        if (isiselement != null) {
            linknode.setIsisISAdjNeighSysID(this.getHostString(isiselement.getNode().getLabel(), "ISSysID", link.getIsisISAdjNeighSysID()));
            linknode.setIsisISAdjUrl(this.getNodeUrl(isiselement.getNode().getId()));
        } else {
            linknode.setIsisISAdjNeighSysID(link.getIsisISAdjNeighSysID());
        }
        linknode.setIsisISAdjNeighSysType(IsIsLink.IsisISAdjNeighSysType.getTypeString((Integer)link.getIsisISAdjNeighSysType().getValue()));
        linknode.setIsisISAdjNeighSNPAAddress(link.getIsisISAdjNeighSNPAAddress());
        linknode.setIsisISAdjState(IsIsLink.IsisISAdjState.get((Integer)link.getIsisISAdjState().getValue()).toString());
        linknode.setIsisISAdjNbrExtendedCircID(link.getIsisISAdjNbrExtendedCircID());
        OnmsSnmpInterface remiface = null;
        if (isiselement != null && (adjLink = adjAndCircIdxToLink.get((Pair<Integer, Integer>)Pair.of((Object)link.getIsisISAdjIndex(), (Object)link.getIsisCircIndex()))) != null) {
            remiface = (OnmsSnmpInterface)snmpInterfaceCache.get(isiselement.getNode().getId(), adjLink.getIsisCircIfIndex());
        }
        if (remiface == null) {
            remiface = adjNeighSnpaAddressToInterface.get(link.getIsisISAdjNeighSNPAAddress());
        }
        if (remiface != null) {
            linknode.setIsisISAdjNeighPort(this.getPortString(remiface, null, null));
            linknode.setIsisISAdjUrl(this.getSnmpInterfaceUrl(remiface.getNode().getId(), remiface.getIfIndex()));
        } else {
            linknode.setIsisISAdjNeighPort("(Isis IS Adj Index: " + link.getIsisISAdjIndex() + ")");
        }
        linknode.setIsisLinkCreateTime(Util.formatDateToUIString(link.getIsisLinkCreateTime()));
        linknode.setIsisLinkLastPollTime(Util.formatDateToUIString(link.getIsisLinkLastPollTime()));
        return linknode;
    }

    @Override
    public List<BridgeElementNode> getBridgeElements(int nodeId) {
        return this.getBridgeElements(nodeId, new BridgeElementCache());
    }

    private List<BridgeElementNode> getBridgeElements(int nodeId, BridgeElementCache bridgeElementCache) {
        ArrayList<BridgeElementNode> nodes = new ArrayList<BridgeElementNode>();
        for (BridgeElement bridge : bridgeElementCache.get(nodeId)) {
            nodes.add(this.convertFromModel(bridge));
        }
        return nodes;
    }

    private BridgeElementNode convertFromModel(BridgeElement bridge) {
        if (bridge == null) {
            return null;
        }
        BridgeElementNode bridgeNode = new BridgeElementNode();
        bridgeNode.setBaseBridgeAddress(bridge.getBaseBridgeAddress());
        bridgeNode.setBaseNumPorts(bridge.getBaseNumPorts());
        bridgeNode.setBaseType(BridgeElement.BridgeDot1dBaseType.getTypeString((Integer)bridge.getBaseType().getValue()));
        bridgeNode.setVlan(bridge.getVlan());
        bridgeNode.setVlanname(bridge.getVlanname());
        if (bridge.getStpProtocolSpecification() != null) {
            bridgeNode.setStpProtocolSpecification(BridgeElement.BridgeDot1dStpProtocolSpecification.getTypeString((Integer)bridge.getStpProtocolSpecification().getValue()));
        }
        bridgeNode.setStpPriority(bridge.getStpPriority());
        bridgeNode.setStpDesignatedRoot(bridge.getStpDesignatedRoot());
        bridgeNode.setStpRootCost(bridge.getStpRootCost());
        bridgeNode.setStpRootPort(bridge.getStpRootPort());
        bridgeNode.setBridgeNodeCreateTime(Util.formatDateToUIString(bridge.getBridgeNodeCreateTime()));
        bridgeNode.setBridgeNodeLastPollTime(Util.formatDateToUIString(bridge.getBridgeNodeLastPollTime()));
        return bridgeNode;
    }

    private BridgeLinkNode convertFromModel(Integer nodeid, SharedSegment segment, BridgeElementCache bridgeElementCache, SnmpInterfaceCache snmpInterfaceCache, Map<String, List<IpNetToMedia>> physAddrToIpNetToMedias, Map<String, List<OnmsIpInterface>> ipAddressToIpInterfaces, UniqueMapCache<String, OnmsSnmpInterface> physAddrToSnmpInterface) {
        BridgeLinkNode linknode = new BridgeLinkNode();
        BridgePort bridgePort = segment.getBridgePort(nodeid);
        OnmsSnmpInterface iface = (OnmsSnmpInterface)snmpInterfaceCache.get(bridgePort.getNodeId(), bridgePort.getBridgePortIfIndex());
        if (iface != null) {
            linknode.setBridgeLocalPort(this.getPortString(iface, "bridgeport", bridgePort.getBridgePort().toString()));
            linknode.setBridgeLocalPortUrl(this.getSnmpInterfaceUrl(bridgePort.getNodeId(), bridgePort.getBridgePortIfIndex()));
        } else {
            linknode.setBridgeLocalPort(this.getPortString("port", bridgePort.getBridgePortIfIndex(), "bridgeport", bridgePort.getBridgePort().toString()));
        }
        BridgeElement bridgeElement = (BridgeElement)bridgeElementCache.get(bridgePort.getNodeId(), bridgePort.getVlan());
        if (bridgeElement != null) {
            linknode.setBridgeInfo(bridgeElement.getVlanname());
        }
        return this.addBridgeRemotesNodes(nodeid, null, linknode, segment, bridgeElementCache, snmpInterfaceCache, physAddrToIpNetToMedias, ipAddressToIpInterfaces, physAddrToSnmpInterface);
    }

    private BridgeLinkNode convertFromModel(Integer nodeid, String mac, List<OnmsIpInterface> ipaddrs, SharedSegment segment, BridgeElementCache bridgeElementCache, SnmpInterfaceCache snmpInterfaceCache, Map<String, List<IpNetToMedia>> physAddrToIpNetToMedias, Map<String, List<OnmsIpInterface>> ipAddressToIpInterfaces, UniqueMapCache<String, OnmsSnmpInterface> physAddrToSnmpInterface) {
        BridgeLinkNode linknode = new BridgeLinkNode();
        if (ipaddrs.size() == 0) {
            linknode.setBridgeLocalPort(this.getIdString("mac", mac));
        } else if (ipaddrs.size() == 1) {
            OnmsIpInterface ipiface = ipaddrs.iterator().next();
            if (ipiface != null) {
                OnmsSnmpInterface snmpiface = ipiface.getSnmpInterface();
                if (snmpiface != null) {
                    linknode.setBridgeLocalPort(this.getPortString(snmpiface, "mac", mac));
                    linknode.setBridgeLocalPortUrl(this.getSnmpInterfaceUrl(snmpiface.getNodeId(), snmpiface.getIfIndex()));
                } else {
                    linknode.setBridgeLocalPort(this.getPortString(InetAddressUtils.str((InetAddress)ipiface.getIpAddress()), ipiface.getIfIndex(), "mac", mac));
                    linknode.setBridgeLocalPortUrl(this.getIpInterfaceUrl(ipiface.getNodeId(), InetAddressUtils.str((InetAddress)ipiface.getIpAddress())));
                }
            }
        } else {
            linknode.setBridgeLocalPort(this.getPortString(this.getIpListAsStringFromIpInterface(ipaddrs), null, "mac", mac));
        }
        return this.addBridgeRemotesNodes(nodeid, mac, linknode, segment, bridgeElementCache, snmpInterfaceCache, physAddrToIpNetToMedias, ipAddressToIpInterfaces, physAddrToSnmpInterface);
    }

    private BridgeLinkNode addBridgeRemotesNodes(Integer nodeid, String mac, BridgeLinkNode linknode, SharedSegment segment, BridgeElementCache bridgeElementCache, SnmpInterfaceCache snmpInterfaceCache, Map<String, List<IpNetToMedia>> physAddrToIpNetToMedias, Map<String, List<OnmsIpInterface>> ipAddressToIpInterfaces, UniqueMapCache<String, OnmsSnmpInterface> physAddrToSnmpInterface) {
        linknode.setBridgeLinkCreateTime(Util.formatDateToUIString(segment.getCreateTime()));
        linknode.setBridgeLinkLastPollTime(Util.formatDateToUIString(segment.getLastPollTime()));
        for (BridgePort remport : segment.getBridgePortsOnSegment()) {
            if (nodeid.intValue() == remport.getNodeId().intValue()) continue;
            BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
            BridgeElement remBridgeElement = (BridgeElement)bridgeElementCache.get(remport.getNodeId(), remport.getVlan());
            if (remBridgeElement != null) {
                remlinknode.setBridgeRemote(this.getHostString(remBridgeElement.getNode().getLabel(), "bridge base address", remBridgeElement.getBaseBridgeAddress()));
            } else {
                remlinknode.setBridgeRemote(this.getIdString("nodeid", remport.getNodeId().toString()));
            }
            remlinknode.setBridgeRemoteUrl(this.getNodeUrl(remport.getNodeId()));
            OnmsSnmpInterface remiface = (OnmsSnmpInterface)snmpInterfaceCache.get(remport.getNodeId(), remport.getBridgePortIfIndex());
            if (remiface != null) {
                remlinknode.setBridgeRemotePort(this.getPortString(remiface, "bridgeport", remport.getBridgePort().toString()));
                remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(remport.getNodeId(), remport.getBridgePortIfIndex()));
            } else {
                remlinknode.setBridgeRemotePort(this.getPortString(null, remport.getBridgePortIfIndex(), "bridgeport", remport.getBridgePort().toString()));
            }
            linknode.getBridgeLinkRemoteNodes().add(remlinknode);
        }
        HashMap<String, List<IpNetToMedia>> macsToIpNetTOMediaMap = new HashMap<String, List<IpNetToMedia>>();
        for (String sharedmac : segment.getMacsOnSegment()) {
            if (sharedmac.equals(mac)) continue;
            List<Object> ipNetToMedias = physAddrToIpNetToMedias.get(sharedmac);
            if (ipNetToMedias == null) {
                ipNetToMedias = Collections.emptyList();
            }
            macsToIpNetTOMediaMap.put(sharedmac, ipNetToMedias);
        }
        for (String sharedmac : macsToIpNetTOMediaMap.keySet()) {
            BridgeLinkRemoteNode remlinknode = new BridgeLinkRemoteNode();
            if (((List)macsToIpNetTOMediaMap.get(sharedmac)).isEmpty()) {
                OnmsSnmpInterface snmp = physAddrToSnmpInterface.get(sharedmac);
                if (snmp == null) {
                    remlinknode.setBridgeRemote(this.getIdString("mac", sharedmac));
                } else {
                    remlinknode.setBridgeRemote(this.getHostString(snmp.getNode().getLabel(), "mac", sharedmac));
                    remlinknode.setBridgeRemoteUrl(this.getNodeUrl(snmp.getNode().getId()));
                    remlinknode.setBridgeRemotePort(this.getPortString(snmp, null, null));
                    remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(snmp.getNode().getId(), snmp.getIfIndex()));
                }
                linknode.getBridgeLinkRemoteNodes().add(remlinknode);
                continue;
            }
            ArrayList<OnmsIpInterface> remipaddrs = new ArrayList<OnmsIpInterface>();
            for (IpNetToMedia ipnettomedia : (List)macsToIpNetTOMediaMap.get(sharedmac)) {
                List<Object> byIpAddress = ipAddressToIpInterfaces.get(ipnettomedia.getNetAddress().getHostAddress());
                if (byIpAddress == null) {
                    byIpAddress = Collections.emptyList();
                }
                remipaddrs.addAll(byIpAddress);
            }
            if (remipaddrs.size() == 0) {
                remlinknode.setBridgeRemote(this.getIdString("mac", sharedmac));
                remlinknode.setBridgeRemotePort(this.getIpListAsStringFromIpNetToMedia((List)macsToIpNetTOMediaMap.get(sharedmac)));
                linknode.getBridgeLinkRemoteNodes().add(remlinknode);
                continue;
            }
            if (remipaddrs.size() == 1) {
                OnmsIpInterface remiface = (OnmsIpInterface)remipaddrs.iterator().next();
                remlinknode.setBridgeRemote(this.getHostString(remiface.getNode().getLabel(), "mac", sharedmac));
                remlinknode.setBridgeRemoteUrl(this.getNodeUrl(remiface.getNodeId()));
                OnmsSnmpInterface remsnmpiface = remiface.getSnmpInterface();
                if (remsnmpiface != null) {
                    remlinknode.setBridgeRemotePort(this.getPortString(remsnmpiface, "ip", InetAddressUtils.str((InetAddress)remiface.getIpAddress())));
                    remlinknode.setBridgeRemotePortUrl(this.getSnmpInterfaceUrl(remiface.getNodeId(), remsnmpiface.getIfIndex()));
                } else {
                    remlinknode.setBridgeRemotePort(this.getPortString(InetAddressUtils.str((InetAddress)remiface.getIpAddress()), remiface.getIfIndex(), null, null));
                    remlinknode.setBridgeRemotePortUrl(this.getIpInterfaceUrl(remiface.getNodeId(), InetAddressUtils.str((InetAddress)remiface.getIpAddress())));
                }
                linknode.getBridgeLinkRemoteNodes().add(remlinknode);
                continue;
            }
            HashSet<String> labels = new HashSet<String>();
            for (OnmsIpInterface remiface : remipaddrs) {
                labels.add(remiface.getNode().getLabel());
            }
            if (labels.size() == 1) {
                remlinknode.setBridgeRemote(this.getHostString((String)labels.iterator().next(), "mac", sharedmac));
                remlinknode.setBridgeRemoteUrl(this.getNodeUrl(((OnmsIpInterface)remipaddrs.iterator().next()).getNodeId()));
            }
            remlinknode.setBridgeRemotePort(this.getIpListAsStringFromIpNetToMedia((List)macsToIpNetTOMediaMap.get(sharedmac)));
            linknode.getBridgeLinkRemoteNodes().add(remlinknode);
        }
        return linknode;
    }

    @Override
    public List<BridgeLinkNode> getBridgeLinks(int nodeId) {
        return this.getBridgeLinks(nodeId, new BridgeElementCache(), new SnmpInterfaceCache());
    }

    private List<BridgeLinkNode> getBridgeLinks(int nodeId, BridgeElementCache bridgeElementCache, SnmpInterfaceCache snmpInterfaceCache) {
        ArrayList<BridgeLinkNode> bridgelinks = new ArrayList<BridgeLinkNode>();
        Map<String, List<IpNetToMedia>> physAddrToIpNetToMedias = this.m_ipNetToMediaDao.findByMacLinksOfNode(Integer.valueOf(nodeId)).stream().collect(Collectors.groupingBy(IpNetToMedia::getPhysAddress));
        Map<String, List<OnmsIpInterface>> ipAddressToIpInterfaces = this.m_ipInterfaceDao.findByMacLinksOfNode(Integer.valueOf(nodeId)).stream().collect(Collectors.groupingBy(itf -> itf.getIpAddress().getHostAddress()));
        UniqueMapCache<String, OnmsSnmpInterface> physAddrToSnmpInterface = EnLinkdElementFactory.uniqueMapCache(() -> this.m_snmpInterfaceDao.findByMacLinksOfNode(Integer.valueOf(nodeId)), OnmsSnmpInterface::getPhysAddr, OnmsSnmpInterface::getId);
        for (SharedSegment segment : this.m_bridgeTopologyService.getSharedSegments(nodeId)) {
            bridgelinks.add(this.convertFromModel(nodeId, segment, bridgeElementCache, snmpInterfaceCache, physAddrToIpNetToMedias, ipAddressToIpInterfaces, physAddrToSnmpInterface));
        }
        if (bridgelinks.size() > 0) {
            Collections.sort(bridgelinks);
            LOG.debug("getBridgeLinks: node:[{}] is bridge found {} bridgelinks", (Object)nodeId, (Object)bridgelinks.size());
            return bridgelinks;
        }
        HashMap mactoIpNodeMap = new HashMap();
        this.m_ipInterfaceDao.findByNodeId(Integer.valueOf(nodeId)).stream().forEach(ip -> {
            LOG.debug("getBridgeLinks: node:[{}] is host found ip:{}", (Object)nodeId, (Object)InetAddressUtils.str((InetAddress)ip.getIpAddress()));
            this.m_ipNetToMediaDao.findByNetAddress(ip.getIpAddress()).stream().forEach(ipnettomedia -> {
                if (!mactoIpNodeMap.containsKey(ipnettomedia.getPhysAddress())) {
                    mactoIpNodeMap.put(ipnettomedia.getPhysAddress(), new ArrayList());
                }
                ((List)mactoIpNodeMap.get(ipnettomedia.getPhysAddress())).add(ip);
                LOG.debug("getBridgeLinks: node:[{}] is host found ip:{} mac:{}", new Object[]{nodeId, InetAddressUtils.str((InetAddress)ip.getIpAddress()), ipnettomedia.getPhysAddress()});
            });
        });
        for (String mac : mactoIpNodeMap.keySet()) {
            SharedSegment segment = this.m_bridgeTopologyService.getSharedSegment(mac);
            if (segment.isEmpty()) continue;
            bridgelinks.add(this.convertFromModel(nodeId, mac, (List)mactoIpNodeMap.get(mac), segment, bridgeElementCache, snmpInterfaceCache, physAddrToIpNetToMedias, ipAddressToIpInterfaces, physAddrToSnmpInterface));
        }
        Collections.sort(bridgelinks);
        return bridgelinks;
    }

    @Override
    public EnLinkdElementFactoryInterface.ElementsAndLinks getAll(int nodeId) {
        SnmpInterfaceCache snmpInterfaceCache = new SnmpInterfaceCache();
        BridgeElementCache bridgeElementCache = new BridgeElementCache();
        return new EnLinkdElementFactoryInterface.ElementsAndLinks(this.getBridgeElements(nodeId, bridgeElementCache), this.getBridgeLinks(nodeId, bridgeElementCache, snmpInterfaceCache), this.getIsisElement(nodeId), this.getIsisLinks(nodeId, snmpInterfaceCache), this.getLldpElement(nodeId), this.getLldpLinks(nodeId), this.getOspfElement(nodeId), this.getOspfLinks(nodeId, snmpInterfaceCache), this.getCdpElement(nodeId), this.getCdpLinks(nodeId, snmpInterfaceCache));
    }

    private OnmsSnmpInterface getFromCdpCacheDevicePort(Integer nodeid, String cdpCacheDevicePort, SnmpInterfaceCache snmpInterfaceCache) {
        List nodes = snmpInterfaceCache.get(nodeid).stream().filter(i -> cdpCacheDevicePort.equals(i.getIfAlias()) || cdpCacheDevicePort.equals(i.getIfName()) || cdpCacheDevicePort.equals(i.getIfDescr())).collect(Collectors.toList());
        return nodes.size() == 1 ? (OnmsSnmpInterface)nodes.get(0) : null;
    }

    private String getPortString(OnmsSnmpInterface snmpiface, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (snmpiface != null) {
            sb.append(snmpiface.getIfName());
            sb.append("(");
            sb.append(snmpiface.getIfAlias());
            sb.append(")");
            sb.append("(ifindex:");
            sb.append(snmpiface.getIfIndex());
            sb.append(")");
        }
        sb.append(this.getIdString(addrtype, addr));
        return sb.toString();
    }

    private String getPortString(String ifname, Integer ifindex, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (ifname != null) {
            sb.append(ifname);
        }
        if (ifindex != null) {
            sb.append("(ifindex:");
            sb.append(ifindex);
            sb.append(")");
        }
        sb.append(this.getIdString(addrtype, addr));
        return sb.toString();
    }

    private String getPortString(Integer ifindex, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (ifindex != null) {
            sb.append("(ifindex:");
            sb.append(ifindex);
            sb.append(")");
        }
        sb.append(this.getIdString(addrtype, addr));
        return sb.toString();
    }

    private String getHostString(String label, String addrtype, String addr) {
        StringBuffer sb = new StringBuffer(label);
        if (addrtype != null && !label.equals(addr)) {
            sb.append(this.getIdString(addrtype, addr));
        }
        return sb.toString();
    }

    private String getIdString(String addrtype, String addr) {
        StringBuffer sb = new StringBuffer("");
        if (addrtype != null) {
            sb.append("(");
            if ("ip".equals(addrtype)) {
                sb.append(addr);
            } else if (addr == null) {
                sb.append(addrtype);
            } else {
                sb.append(addrtype);
                sb.append(":");
                sb.append(addr);
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private String getNodeUrl(Integer nodeid) {
        return "element/linkednode.jsp?node=" + nodeid;
    }

    private String getSnmpInterfaceUrl(Integer nodeid, Integer ifindex) {
        if (ifindex != null && nodeid != null) {
            return "element/snmpinterface.jsp?node=" + nodeid + "&ifindex=" + ifindex;
        }
        return null;
    }

    private String getIpInterfaceUrl(Integer nodeid, String ipaddress) {
        return "element/interface.jsp?node=" + nodeid + "&intf=" + ipaddress;
    }

    private String getIpListAsStringFromIpInterface(List<OnmsIpInterface> ipinterfaces) {
        HashSet<String> ipstrings = new HashSet<String>();
        ipinterfaces.stream().forEach(ipinterface -> ipstrings.add(InetAddressUtils.str((InetAddress)ipinterface.getIpAddress())));
        return this.getIpList(ipstrings);
    }

    private String getIpListAsStringFromIpNetToMedia(List<IpNetToMedia> ipnettomedias) {
        HashSet<String> ipstrings = new HashSet<String>();
        ipnettomedias.stream().forEach(ipnettomedia -> ipstrings.add(InetAddressUtils.str((InetAddress)ipnettomedia.getNetAddress())));
        return this.getIpList(ipstrings);
    }

    private String getIpList(Set<String> ipstrings) {
        StringBuffer sb = new StringBuffer("(");
        boolean start = true;
        for (String ipstring : ipstrings) {
            if (start) {
                start = false;
            } else {
                sb.append(":");
            }
            sb.append(ipstring);
        }
        sb.append(")");
        return sb.toString();
    }

    private static <K, V, I> UniqueMapCache<K, V> uniqueMapCache(final Supplier<List<V>> supplier, final Function<V, K> toKey, final Function<V, I> toId) {
        return new UniqueMapCache<K, V>(){
            private Map<K, Optional<V>> map;

            @Override
            public V get(K key) {
                Optional o;
                if (this.map == null) {
                    this.map = EnLinkdElementFactory.uniqueMap((List)supplier.get(), toKey, toId);
                }
                return (o = this.map.get(key)) == null ? null : o.orElse(null);
            }
        };
    }

    private static <K, V, I> Map<K, Optional<V>> uniqueMap(List<V> list, Function<V, K> toKey, Function<V, I> toId) {
        return list.stream().collect(Collectors.toMap(toKey, Optional::of, (o1, o2) -> o1.flatMap(v1 -> o2.flatMap(v2 -> toId.apply(v1).equals(toId.apply(v2)) ? o1 : Optional.empty()))));
    }

    private static interface UniqueMapCache<K, V> {
        public V get(K var1);
    }

    private class BridgeElementCache
    extends ListAndUniqueMapCache<BridgeElement, Integer> {
        public BridgeElementCache() {
            super(arg_0 -> ((BridgeElementDao)EnLinkdElementFactory.this.m_bridgeElementDao).findByNodeId(arg_0), BridgeElement::getVlan, BridgeElement::getId);
        }
    }

    private class SnmpInterfaceCache
    extends ListAndUniqueMapCache<OnmsSnmpInterface, Integer> {
        public SnmpInterfaceCache() {
            super(arg_0 -> ((SnmpInterfaceDao)EnLinkdElementFactory.this.m_snmpInterfaceDao).findByNodeId(arg_0), OnmsSnmpInterface::getIfIndex, OnmsSnmpInterface::getId);
        }
    }

    private static abstract class ListAndUniqueMapCache<T, S> {
        private final Function<Integer, List<T>> loader;
        private final Function<T, S> selector;
        private final Function<T, Integer> identifier;
        private Map<Integer, Pair<List<T>, UniqueMapCache<S, T>>> map = new HashMap<Integer, Pair<List<T>, UniqueMapCache<S, T>>>();

        public ListAndUniqueMapCache(Function<Integer, List<T>> loader, Function<T, S> selector, Function<T, Integer> identifier) {
            this.loader = loader;
            this.selector = selector;
            this.identifier = identifier;
        }

        private Pair<List<T>, UniqueMapCache<S, T>> pair(int nodeId) {
            return this.map.computeIfAbsent(nodeId, n -> {
                List list = this.loader.apply((Integer)n);
                UniqueMapCache uniqueMapCache = EnLinkdElementFactory.uniqueMapCache(() -> list, this.selector, this.identifier);
                return Pair.of(list, uniqueMapCache);
            });
        }

        public List<T> get(int nodeId) {
            return (List)this.pair(nodeId).getLeft();
        }

        public T get(int nodeId, S selection) {
            if (selection == null) {
                return null;
            }
            return (T)((UniqueMapCache)this.pair(nodeId).getRight()).get(selection);
        }
    }
}

