/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.net.InetAddress;
import java.util.Collection;
import java.util.LinkedList;
import org.opennms.netmgt.model.InetAddressTypeEditor;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSeverityEditor;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.PrimaryTypeEditor;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;

public interface PropertyUtils {
    public static Collection<String> getProperties(Object bean) {
        LinkedList<String> props = new LinkedList<String>();
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        for (PropertyDescriptor pd : wrapper.getPropertyDescriptors()) {
            props.add(pd.getName());
        }
        return props;
    }

    public static <T> T getPathValue(Object bean, String path, Class<T> expectedClass) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        wrapper.registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressTypeEditor());
        wrapper.registerCustomEditor(OnmsSeverity.class, (PropertyEditor)new OnmsSeverityEditor());
        wrapper.registerCustomEditor(PrimaryType.class, (PropertyEditor)new PrimaryTypeEditor());
        try {
            Class propType = wrapper.getPropertyType(path);
            if (!expectedClass.isAssignableFrom(propType)) {
                throw new IllegalArgumentException("Could not retrieve property of type " + propType + " as type " + expectedClass);
            }
        }
        catch (BeansException e) {
            LoggerFactory.getLogger(PropertyUtils.class).warn("propType in BeanUtils is null for path: {}", (Object)path);
            return null;
        }
        return (T)wrapper.getPropertyValue(path);
    }
}

