/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.model;

import java.text.DecimalFormat;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.OnmsNode;

@XmlRootElement(name="rtc-node")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RtcNode {
    private static final DecimalFormat AVAILABILITY_FORMAT = new DecimalFormat("0.000%");
    @XmlElement(name="node")
    private OnmsNode m_node;
    @XmlAttribute(name="service-count")
    private int m_serviceCount;
    @XmlAttribute(name="down-service-count")
    private int m_downServiceCount;
    @XmlAttribute(name="availability")
    private double m_availability;

    public RtcNode(OnmsNode node, int serviceCount, int downServiceCount, double availability) {
        this.m_node = node;
        this.m_serviceCount = serviceCount;
        this.m_downServiceCount = downServiceCount;
        this.m_availability = availability;
    }

    public double getAvailability() {
        return this.m_availability;
    }

    public String getAvailabilityAsString() {
        return AVAILABILITY_FORMAT.format(this.m_availability);
    }

    public int getDownServiceCount() {
        return this.m_downServiceCount;
    }

    public OnmsNode getNode() {
        return this.m_node;
    }

    public int getServiceCount() {
        return this.m_serviceCount;
    }

    public String toString() {
        return this.m_node.getLabel() + ": " + this.m_downServiceCount + " of " + this.m_serviceCount + ": " + this.getAvailabilityAsString();
    }

    static {
        AVAILABILITY_FORMAT.setMultiplier(100);
    }
}

