/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;

public abstract class UriInfoUtils {
    private UriInfoUtils() {
    }

    public static boolean hasKey(UriInfo uriInfo, String key) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        return UriInfoUtils.hasKey((MultivaluedMap<String, String>)params, key);
    }

    public static boolean hasKey(MultivaluedMap<String, String> params, String key) {
        return params.containsKey((Object)key) && params.getFirst((Object)key) != null && !"".equals(((String)params.getFirst((Object)key)).trim());
    }

    public static String getValue(UriInfo uriInfo, String key, String defaultValue) {
        if (UriInfoUtils.hasKey(uriInfo, key)) {
            return ((String)uriInfo.getQueryParameters().getFirst((Object)key)).trim();
        }
        return defaultValue;
    }

    public static List<String> getValues(UriInfo uriInfo, String key) {
        return UriInfoUtils.getValues(uriInfo, key, Collections.emptyList());
    }

    public static List<String> getValues(UriInfo uriInfo, String key, List<String> defaultValue) {
        if (UriInfoUtils.hasKey(uriInfo, key)) {
            Set uniqueValues = ((List)uriInfo.getQueryParameters().get((Object)key)).stream().map(g -> g != null ? g.trim() : g).filter(g -> g != null).collect(Collectors.toSet());
            return new ArrayList<String>(uniqueValues);
        }
        return defaultValue;
    }
}

