/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.concurrent;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class FutureUtils {
    private static Timer timer = new Timer("opennms.FutureUtils", true);

    public static <T> CompletionStage<T> completionStageWithDefaultOnTimeout(Callable<T> callable, Duration timeout, Supplier<T> defaultValue, ExecutorService executorService) {
        return FutureUtils.completionStage(callable, timeout, (CompletableFuture<T> cf) -> cf.complete(defaultValue.get()), executorService);
    }

    public static <T, EX extends Throwable> CompletionStage<T> completionStageWithTimeoutException(Callable<T> callable, Duration timeout, Supplier<EX> timeoutException, ExecutorService executorService) {
        return FutureUtils.completionStage(callable, timeout, (CompletableFuture<T> cf) -> cf.completeExceptionally((Throwable)timeoutException.get()), executorService);
    }

    public static <T> CompletionStage<T> completionStage(Callable<T> callable, Duration timeout, Consumer<CompletableFuture<T>> onTimeout, ExecutorService executorService) {
        return FutureUtils.completionStage((CompletableFuture<T> result) -> result.complete(callable.call()), timeout, onTimeout, executorService);
    }

    public static <T> CompletionStage<T> completionStage(Completer<T> completer, Duration timeout, final Consumer<CompletableFuture<T>> onTimeout, ExecutorService executorService) {
        final CompletableFuture result = new CompletableFuture();
        final Future<?> future = executorService.submit(() -> {
            try {
                completer.completeNowOrLater(result);
            }
            catch (Throwable e) {
                result.completeExceptionally(e);
            }
        });
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                onTimeout.accept(result);
                future.cancel(true);
            }
        };
        timer.schedule(timerTask, timeout.toMillis());
        result.thenRun((timerTask)::cancel);
        return result;
    }

    public static <T> CompletionStage<List<T>> sequence(List<CompletionStage<T>> cfs) {
        return FutureUtils.traverse(cfs, Function.identity());
    }

    public static <U, V> CompletionStage<List<V>> traverse(List<U> us, Function<U, CompletionStage<V>> func) {
        List futures = us.stream().map(func).collect(Collectors.toList());
        CompletionStage<List<Object>> result = CompletableFuture.completedFuture(new ArrayList());
        for (CompletionStage f : futures) {
            result = result.thenCombine(f, (list, item) -> {
                list.add(item);
                return list;
            });
        }
        return result;
    }

    @FunctionalInterface
    public static interface Completer<T> {
        public void completeNowOrLater(CompletableFuture<T> var1) throws Exception;
    }
}

