/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OnmsSeverity implements Serializable
{
    INDETERMINATE(1, "Indeterminate", "lightblue"),
    CLEARED(2, "Cleared", "white"),
    NORMAL(3, "Normal", "green"),
    WARNING(4, "Warning", "cyan"),
    MINOR(5, "Minor", "yellow"),
    MAJOR(6, "Major", "orange"),
    CRITICAL(7, "Critical", "red");

    private static final Map<Integer, OnmsSeverity> m_idMap;
    private int m_id;
    private String m_label;
    private String m_color;

    private OnmsSeverity(int id, String label, String color) {
        this.m_id = id;
        this.m_label = label;
        this.m_color = color;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getColor() {
        return this.m_color;
    }

    public boolean isLessThan(OnmsSeverity other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqual(OnmsSeverity other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(OnmsSeverity other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqual(OnmsSeverity other) {
        return this.compareTo(other) >= 0;
    }

    public static OnmsSeverity get(int id) {
        if (m_idMap.containsKey(id)) {
            return m_idMap.get(id);
        }
        throw new IllegalArgumentException("Cannot create OnmsSeverity from unknown ID " + id);
    }

    public static OnmsSeverity get(String label) {
        for (Integer key : m_idMap.keySet()) {
            if (!m_idMap.get(key).getLabel().equalsIgnoreCase(label)) continue;
            return m_idMap.get(key);
        }
        return INDETERMINATE;
    }

    public static OnmsSeverity escalate(OnmsSeverity sev) {
        if (sev.isLessThan(CRITICAL)) {
            return OnmsSeverity.get(sev.getId() + 1);
        }
        return OnmsSeverity.get(sev.getId());
    }

    public static List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (OnmsSeverity value : OnmsSeverity.values()) {
            names.add(value.toString());
        }
        return names;
    }

    static {
        m_idMap = new HashMap<Integer, OnmsSeverity>(OnmsSeverity.values().length);
        for (OnmsSeverity severity : OnmsSeverity.values()) {
            m_idMap.put(severity.getId(), severity);
        }
    }
}

