/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.events;

import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEventVisitor
extends AbstractEntityVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(AddEventVisitor.class);
    private static final String m_eventSource = "Provisiond";
    private final EventForwarder m_eventForwarder;
    private String monitorKey;

    public AddEventVisitor(EventForwarder eventForwarder) {
        this(eventForwarder, null);
    }

    public AddEventVisitor(EventForwarder eventForwarder, String monitorKey) {
        this.m_eventForwarder = eventForwarder;
        this.monitorKey = monitorKey;
    }

    @Override
    public void visitNode(OnmsNode node) {
        LOG.info("Sending nodeAdded Event for {}\n", (Object)node);
        this.m_eventForwarder.sendNow(this.createNodeAddedEvent(node));
        if (node.getCategories().size() > 0) {
            String[] categoriesAdded = (String[])node.getCategories().stream().map(OnmsCategory::getName).toArray(String[]::new);
            this.m_eventForwarder.sendNow(this.createNodeCategoryMembershipChangedEvent(node, categoriesAdded, new String[0]));
        }
    }

    @Override
    public void visitIpInterface(OnmsIpInterface iface) {
        LOG.info("Sending nodeGainedInterface Event for {}\n", (Object)iface);
        this.m_eventForwarder.sendNow(this.createNodeGainedInterfaceEvent(iface));
    }

    @Override
    public void visitMonitoredService(OnmsMonitoredService monSvc) {
        LOG.info("Sending nodeGainedService Event for {}\n", (Object)monSvc);
        this.m_eventForwarder.sendNow(this.createNodeGainedServiceEvent(monSvc));
    }

    protected Event createNodeAddedEvent(OnmsNode node) {
        return EventUtils.createNodeAddedEvent(m_eventSource, node.getId(), node.getLabel(), node.getLabelSource(), this.monitorKey);
    }

    private Event createNodeCategoryMembershipChangedEvent(OnmsNode node, String[] categoriesAdded, String[] categoriesDeleted) {
        return EventUtils.createNodeCategoryMembershipChangedEvent(m_eventSource, node.getId(), node.getLabel(), categoriesAdded, categoriesDeleted);
    }

    protected Event createNodeGainedInterfaceEvent(OnmsIpInterface iface) {
        return EventUtils.createNodeGainedInterfaceEvent(m_eventSource, iface.getNode().getId(), iface.getIpAddress());
    }

    protected Event createNodeGainedServiceEvent(OnmsMonitoredService monSvc) {
        OnmsIpInterface iface = monSvc.getIpInterface();
        OnmsNode node = iface.getNode();
        LOG.debug("ipinterface = {}", (Object)iface);
        LOG.debug("snmpinterface = {}", (Object)iface.getSnmpInterface());
        LOG.debug("node = {}", (Object)node);
        return EventUtils.createNodeGainedServiceEvent(m_eventSource, monSvc.getNodeId(), iface.getIpAddress(), monSvc.getServiceType().getName(), node.getLabel(), node.getLabelSource(), node.getSysName(), node.getSysDescription());
    }
}

