/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StatusType
implements Comparable<StatusType>,
Serializable {
    private static final long serialVersionUID = -4784344871599250528L;
    private static final char[] s_order = new char[]{'A', 'N', 'D', 'U', 'B', 'G'};
    private char m_statusType;
    private static final Map<Character, String> statusMap = new HashMap<Character, String>();
    public static final StatusType ACTIVE;
    public static final StatusType INACTIVE;
    public static final StatusType DELETED;
    public static final StatusType UNKNOWN;
    public static final StatusType BAD;
    public static final StatusType GOOD;

    private StatusType() {
    }

    public StatusType(char statusType) {
        this.m_statusType = statusType;
    }

    public char getCharCode() {
        return this.m_statusType;
    }

    public void setCharCode(char statusType) {
        this.m_statusType = statusType;
    }

    @Override
    public int compareTo(StatusType o) {
        return StatusType.getIndex(this.m_statusType) - StatusType.getIndex(o.m_statusType);
    }

    private static int getIndex(char code) {
        for (int i = 0; i < s_order.length; ++i) {
            if (s_order[i] != code) continue;
            return i;
        }
        throw new IllegalArgumentException("illegal statusType code '" + code + "'");
    }

    public boolean equals(Object o) {
        if (o instanceof StatusType) {
            return this.m_statusType == ((StatusType)o).m_statusType;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.m_statusType);
    }

    public static StatusType get(char code) {
        switch (code) {
            case 'A': {
                return ACTIVE;
            }
            case 'N': {
                return INACTIVE;
            }
            case 'D': {
                return DELETED;
            }
            case 'U': {
                return UNKNOWN;
            }
            case 'B': {
                return BAD;
            }
            case 'G': {
                return GOOD;
            }
        }
        throw new IllegalArgumentException("Cannot create statusType from code " + code);
    }

    public static String getStatusString(char code) {
        if (statusMap.containsKey(Character.valueOf(code))) {
            return statusMap.get(Character.valueOf(code));
        }
        return null;
    }

    public static StatusType get(String code) {
        if (code == null) {
            return UNKNOWN;
        }
        if ((code = code.trim()).length() < 1) {
            return UNKNOWN;
        }
        if (code.length() > 1) {
            throw new IllegalArgumentException("Cannot convert string " + code + " to a StatusType");
        }
        return StatusType.get(code.charAt(0));
    }

    static {
        statusMap.put(Character.valueOf('A'), "Active");
        statusMap.put(Character.valueOf('U'), "Unknown");
        statusMap.put(Character.valueOf('D'), "Deleted");
        statusMap.put(Character.valueOf('N'), "Not Active");
        statusMap.put(Character.valueOf('B'), "Bad");
        statusMap.put(Character.valueOf('G'), "Good");
        ACTIVE = new StatusType('A');
        INACTIVE = new StatusType('N');
        DELETED = new StatusType('D');
        UNKNOWN = new StatusType('U');
        BAD = new StatusType('B');
        GOOD = new StatusType('G');
    }
}

