/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model.perspectivepolling;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.perspectivepolling.Location;

@XmlRootElement(name="application-status")
public class ApplicationStatus {
    private Integer applicationId;
    private Long start;
    private Long end;
    private List<Location> locations = new ArrayList<Location>();
    private Double overallStatus;

    @XmlAttribute(name="applicationId")
    public Integer getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(Integer applicationId) {
        this.applicationId = applicationId;
    }

    @XmlAttribute(name="start")
    public Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    @XmlAttribute(name="end")
    public Long getEnd() {
        return this.end;
    }

    public void setEnd(Long end) {
        this.end = end;
    }

    @XmlElement(name="location")
    public List<Location> getLocations() {
        return this.locations;
    }

    public Location getLocation(String location) {
        return this.locations.stream().filter(e -> location.equals(e.getName())).findFirst().orElse(null);
    }

    public void setLocations(List<Location> locations) {
        this.locations = locations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationStatus that = (ApplicationStatus)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(this.locations, that.locations);
    }

    @XmlElement(name="overallStatus")
    public Double getOverallStatus() {
        return this.overallStatus;
    }

    public void setOverallStatus(Double overallStatus) {
        this.overallStatus = overallStatus;
    }

    public int hashCode() {
        return Objects.hash(this.applicationId, this.start, this.end, this.locations, this.overallStatus);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("applicationId", (Object)this.applicationId).add("overallStatus", (Object)this.overallStatus).add("start", (Object)this.start).add("end", (Object)this.end).add("locations", this.locations).toString();
    }
}

