/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.javamail;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.event.TransportEvent;
import javax.mail.event.TransportListener;
import javax.mail.internet.MimeBodyPart;
import org.opennms.javamail.JavaMailerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class JavaMailer2 {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMailer2.class);
    private Session m_session = null;
    private Properties m_mailProps;

    public JavaMailer2(Properties javamailProps) throws JavaMailerException {
    }

    public JavaMailer2() throws JavaMailerException {
        this(new Properties());
    }

    public Authenticator createAuthenticator(final String user, final String password) {
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password);
            }
        };
        return auth;
    }

    public MimeBodyPart createFileAttachment(File file) throws MessagingException, JavaMailerException {
        if (!file.exists()) {
            LOG.error("File attachment '{}' does not exist.", (Object)file.getAbsolutePath());
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' does not exist.");
        }
        if (!file.canRead()) {
            LOG.error("File attachment '{}' is not readable.", (Object)file.getAbsolutePath());
            throw new JavaMailerException("File attachment '" + file.getAbsolutePath() + "' is not readable.");
        }
        MimeBodyPart bodyPart = new MimeBodyPart();
        FileDataSource fds = new FileDataSource(file);
        bodyPart.setDataHandler(new DataHandler((DataSource)fds));
        bodyPart.setFileName(fds.getName());
        return bodyPart;
    }

    public void setDebug(boolean debug) {
        if (debug) {
            this.m_session.setDebugOut(new PrintStream(new LoggingByteArrayOutputStream()));
        }
        this.m_session.setDebug(debug);
    }

    public Session getSession() {
        return this.m_session;
    }

    public void setSession(Session session) {
        this.m_session = session;
    }

    public Properties getMailProps() {
        return this.m_mailProps;
    }

    public static class LoggingTransportListener
    implements TransportListener {
        private static final Logger LOG = LoggerFactory.getLogger(LoggingTransportListener.class);
        private List<Address> m_invalidAddresses = new ArrayList<Address>();
        private List<Address> m_validSentAddresses = new ArrayList<Address>();
        private List<Address> m_validUnsentAddresses = new ArrayList<Address>();

        public void messageDelivered(TransportEvent event) {
            this.logEvent("message delivered", event);
        }

        public void messageNotDelivered(TransportEvent event) {
            this.logEvent("message not delivered", event);
        }

        public void messagePartiallyDelivered(TransportEvent event) {
            this.logEvent("message partially delivered", event);
        }

        private void logEvent(String message, TransportEvent event) {
            if (event.getInvalidAddresses() != null && event.getInvalidAddresses().length > 0) {
                this.m_invalidAddresses.addAll(Arrays.asList(event.getInvalidAddresses()));
                LOG.error("{}: invalid addresses: {}", (Object)message, (Object)StringUtils.arrayToDelimitedString((Object[])event.getInvalidAddresses(), (String)", "));
            }
            if (event.getValidSentAddresses() != null && event.getValidSentAddresses().length > 0) {
                this.m_validSentAddresses.addAll(Arrays.asList(event.getValidSentAddresses()));
                LOG.debug("{}: valid sent addresses: {}", (Object)message, (Object)StringUtils.arrayToDelimitedString((Object[])event.getValidSentAddresses(), (String)", "));
            }
            if (event.getValidUnsentAddresses() != null && event.getValidUnsentAddresses().length > 0) {
                this.m_validUnsentAddresses.addAll(Arrays.asList(event.getValidUnsentAddresses()));
                LOG.error("{}: valid unsent addresses: {}", (Object)message, (Object)StringUtils.arrayToDelimitedString((Object[])event.getValidUnsentAddresses(), (String)", "));
            }
        }

        public boolean hasAnythingBeenReceived() {
            return this.m_invalidAddresses.size() != 0 || this.m_validSentAddresses.size() != 0 || this.m_validUnsentAddresses.size() != 0;
        }

        public void assertAllMessagesDelivered() throws JavaMailerException {
            for (int i = 0; i < 10 && !this.hasAnythingBeenReceived(); ++i) {
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_invalidAddresses.size() == 0 && this.m_validUnsentAddresses.size() == 0) {
                return;
            }
            throw new JavaMailerException("Not all messages delivered:\n\t" + this.m_validSentAddresses.size() + " messages were sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validSentAddresses, (String)", ") + "\n\t" + this.m_validUnsentAddresses.size() + " messages were not sent to valid addresses: " + StringUtils.collectionToDelimitedString(this.m_validUnsentAddresses, (String)", ") + "\n\t" + this.m_invalidAddresses.size() + " messages had invalid addresses: " + StringUtils.collectionToDelimitedString(this.m_invalidAddresses, (String)", "));
        }
    }

    public static class LoggingByteArrayOutputStream
    extends ByteArrayOutputStream {
        private static final Logger LOG = LoggerFactory.getLogger(LoggingByteArrayOutputStream.class);

        @Override
        public void flush() throws IOException {
            super.flush();
            String buffer = this.toString().replaceAll("\n", "");
            if (buffer.length() > 0) {
                LOG.debug(buffer);
            }
            this.reset();
        }
    }
}

