/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.sample.SamplePoller;
import org.opennms.integration.api.v1.collectors.CollectionRequest;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.ServiceCollector;
import org.opennms.integration.api.v1.collectors.immutables.ImmutableNumericAttribute;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.IpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.NodeResource;
import org.opennms.integration.api.v1.collectors.resource.NumericAttribute;
import org.opennms.integration.api.v1.collectors.resource.Resource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableCollectionSet;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableCollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableIpInterfaceResource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableNodeResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleCollector
implements ServiceCollector {
    private static final Logger LOG = LoggerFactory.getLogger(SamplePoller.class);
    private static final String INSTANCE_NAME = "opennms";
    private static final String NODE_CRITERIA = "nodeCriteria";
    private static int nodeId = 0;

    public void initialize() {
    }

    public CompletableFuture<CollectionSet> collect(CollectionRequest agent, Map<String, Object> parameters) {
        CompletableFuture<CollectionSet> future = new CompletableFuture<CollectionSet>();
        try {
            if (agent.getAddress().equals(InetAddress.getLocalHost())) {
                if (parameters.get(NODE_CRITERIA) instanceof String) {
                    String nodeCriteria = (String)parameters.get(NODE_CRITERIA);
                    nodeId = this.getNumeric(nodeCriteria);
                }
                CollectionSet collectionSet = SampleCollector.buildCollectionSet();
                future.complete(collectionSet);
                LOG.info("Sample Collector collection Succeeded");
            } else {
                future.completeExceptionally(new IllegalArgumentException());
            }
        }
        catch (UnknownHostException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public static boolean validateCollectionSet(CollectionSet collectionSet) {
        boolean valid = false;
        CollectionSetResource resource = (CollectionSetResource)collectionSet.getCollectionSetResources().get(0);
        if (resource.getResource().getResourceType().equals((Object)Resource.Type.INTERFACE)) {
            IpInterfaceResource ipInterfaceResource = (IpInterfaceResource)resource.getResource();
            valid = ipInterfaceResource.getInstance().equals(INSTANCE_NAME);
            NodeResource nodeResource = ipInterfaceResource.getNodeResource();
            int result = nodeResource.getNodeId();
            valid = valid && result == nodeId;
        }
        return valid;
    }

    public static CollectionSet buildCollectionSet() {
        ImmutableNodeResource nodeResource = ImmutableNodeResource.newBuilder().setNodeId(Integer.valueOf(nodeId)).build();
        ImmutableIpInterfaceResource ipInterfaceResource = ImmutableIpInterfaceResource.newInstance((NodeResource)nodeResource, (String)INSTANCE_NAME);
        ImmutableNumericAttribute attribute = ImmutableNumericAttribute.newBuilder().setGroup("group").setName("snmp").setValue(Double.valueOf(3.54)).setType(NumericAttribute.Type.GAUGE).build();
        CollectionSetResource collectionSetResource = ImmutableCollectionSetResource.newBuilder(IpInterfaceResource.class).setResource((Resource)ipInterfaceResource).addNumericAttribute((NumericAttribute)attribute).build();
        CollectionSet collectionSet = ImmutableCollectionSet.newBuilder().addCollectionSetResource(collectionSetResource).setTimestamp(System.currentTimeMillis()).build();
        return collectionSet;
    }

    private int getNumeric(String nodeCriteria) {
        try {
            return Integer.parseInt(nodeCriteria);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static class CollectionRequestImpl
    implements CollectionRequest {
        private final int nodeId;

        public CollectionRequestImpl(int nodeId) {
            this.nodeId = nodeId;
        }

        public InetAddress getAddress() {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                return null;
            }
        }

        public String getNodeCriteria() {
            return String.valueOf(this.nodeId);
        }
    }
}

