/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.nrtg.api.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.nrtg.api.model.DefaultMeasurement;
import org.opennms.nrtg.api.model.Measurement;
import org.opennms.nrtg.api.model.MeasurementSet;

public class LightweightMeasurementSet
implements MeasurementSet {
    private static final long serialVersionUID = 1166779403641774595L;
    private Map<String, ArrayList<String>> m_values = new HashMap<String, ArrayList<String>>();
    private int m_nodeId;
    private String m_interface;
    private String m_service;
    private Date m_timestamp = new Date();

    public LightweightMeasurementSet() {
    }

    public LightweightMeasurementSet(int nodeId, String service, String theInterface, Date timestamp) {
        this.setNodeId(nodeId);
        this.setService(service);
        this.setNetInterface(theInterface);
        this.setTimestamp(timestamp);
    }

    public void addMeasurement(String metricId, String metricType, String value, String onmsLogicMetricId) {
        ArrayList<String> valueTypeList = new ArrayList<String>(3);
        valueTypeList.add(metricType);
        valueTypeList.add(value);
        valueTypeList.add(onmsLogicMetricId);
        this.m_values.put(metricId, valueTypeList);
    }

    @Override
    public List<Measurement> getMeasurements() {
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        for (String metricId : this.m_values.keySet()) {
            DefaultMeasurement measurement = new DefaultMeasurement();
            measurement.setTimestamp(this.getTimestamp());
            measurement.setNetInterface(this.getNetInterface());
            measurement.setNodeId(this.getNodeId());
            measurement.setService(this.getService());
            measurement.setMetricId(metricId);
            ArrayList<String> valueTypeList = this.m_values.get(metricId);
            measurement.setMetricType(valueTypeList.get(0));
            measurement.setValue(valueTypeList.get(1));
            measurement.setOnmsLogicMetricId(valueTypeList.get(2));
            measurements.add(measurement);
        }
        return measurements;
    }

    public void setNodeId(int nodeId) {
        this.m_nodeId = nodeId;
    }

    public void setNetInterface(String theInterface) {
        this.m_interface = theInterface;
    }

    public void setService(String service) {
        this.m_service = service;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    public int getNodeId() {
        return this.m_nodeId;
    }

    public String getNetInterface() {
        return this.m_interface;
    }

    public String getService() {
        return this.m_service;
    }

    public Date getTimestamp() {
        return this.m_timestamp;
    }

    @Override
    public String getJson() {
        StringBuilder buf = new StringBuilder("[");
        boolean first = true;
        for (Measurement m : this.getMeasurements()) {
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            buf.append("{");
            buf.append("\"metricId\"").append(":\"").append(m.getMetricId()).append("\",");
            buf.append("\"metricType\"").append(":\"").append(m.getMetricType()).append("\",");
            buf.append("\"netInterface\"").append(":\"").append(m.getNetInterface()).append("\",");
            buf.append("\"nodeId\"").append(":").append(m.getNodeId()).append(",");
            buf.append("\"service\"").append(":\"").append(m.getService()).append("\",");
            buf.append("\"timeStamp\"").append(":").append(m.getTimestamp().getTime()).append(",");
            buf.append("\"onmsLogicMetricId\"").append(":\"").append(m.getOnmsLogicMetricId()).append("\",");
            buf.append("\"value\"").append(":").append(m.getValue());
            buf.append("}");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toString() {
        return this.getJson();
    }
}

