/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle;

import com.google.gradle.osdetector.OsDetector;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;

public enum JavaFXPlatform {
    LINUX("linux", "linux-x86_64", "linux", "x86-64"),
    LINUX_AARCH64("linux-aarch64", "linux-aarch_64", "linux", "aarch64"),
    WINDOWS("win", "windows-x86_64", "windows", "x86-64"),
    OSX("mac", "osx-x86_64", "macos", "x86-64"),
    OSX_AARCH64("mac-aarch64", "osx-aarch_64", "macos", "aarch64");

    private final String classifier;
    private final String osDetectorClassifier;
    private final String osFamily;
    private final String arch;

    private JavaFXPlatform(String classifier, String osDetectorClassifier, String osFamily, String arch) {
        this.classifier = classifier;
        this.osDetectorClassifier = osDetectorClassifier;
        this.osFamily = osFamily;
        this.arch = arch;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getArch() {
        return this.arch;
    }

    public static JavaFXPlatform detect(OsDetector osDetector) {
        String osClassifier = osDetector.getClassifier();
        for (JavaFXPlatform platform : JavaFXPlatform.values()) {
            if (!platform.osDetectorClassifier.equals(osClassifier)) continue;
            return platform;
        }
        String supportedPlatforms = Arrays.stream(JavaFXPlatform.values()).map(p -> p.osDetectorClassifier).collect(Collectors.joining("', '", "'", "'"));
        throw new GradleException(String.format("Unsupported JavaFX platform found: '%s'! This plugin is designed to work on supported platforms only.Current supported platforms are %s.", osClassifier, supportedPlatforms));
    }

    public static JavaFXPlatform fromString(String platform) {
        switch (platform) {
            case "linux": {
                return LINUX;
            }
            case "linux-aarch64": {
                return LINUX_AARCH64;
            }
            case "win": 
            case "windows": {
                return WINDOWS;
            }
            case "osx": 
            case "mac": 
            case "macos": {
                return OSX;
            }
            case "osx-aarch64": 
            case "mac-aarch64": 
            case "macos-aarch64": {
                return OSX_AARCH64;
            }
        }
        return JavaFXPlatform.valueOf(platform);
    }
}

