/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx.gradle.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.javamodularity.moduleplugin.tasks.ModuleOptions;
import org.openjfx.gradle.JavaFXModule;
import org.openjfx.gradle.JavaFXOptions;
import org.openjfx.gradle.JavaFXPlatform;

public class ExecTask
extends DefaultTask {
    private final Project project;
    private JavaExec execTask;

    @Inject
    public ExecTask(Project project) {
        this.project = project;
        project.getPluginManager().withPlugin("application", e -> {
            this.execTask = (JavaExec)project.getTasks().findByName("run");
            if (this.execTask == null) {
                throw new GradleException("Run task not found.");
            }
            this.execTask.dependsOn(new Object[]{this});
        });
    }

    @TaskAction
    public void action() {
        if (this.execTask != null) {
            JavaFXOptions javaFXOptions = (JavaFXOptions)this.project.getExtensions().getByType(JavaFXOptions.class);
            JavaFXModule.validateModules(javaFXOptions.getModules());
            TreeSet<String> definedJavaFXModuleNames = new TreeSet<String>(javaFXOptions.getModules());
            if (!definedJavaFXModuleNames.isEmpty()) {
                ModuleOptions moduleOptions = (ModuleOptions)this.execTask.getExtensions().findByType(ModuleOptions.class);
                if (moduleOptions != null) {
                    definedJavaFXModuleNames.forEach(javaFXModule -> moduleOptions.getAddModules().add(javaFXModule));
                } else {
                    List<String> javaFXModuleJvmArgs = List.of("--module-path", this.execTask.getClasspath().filter(jar -> ExecTask.isJavaFXJar(jar, javaFXOptions.getVersion(), javaFXOptions.getPlatform())).getAsPath());
                    ArrayList<String> jvmArgs = new ArrayList<String>();
                    jvmArgs.add("--add-modules");
                    jvmArgs.add(String.join((CharSequence)",", definedJavaFXModuleNames));
                    List execJvmArgs = this.execTask.getJvmArgs();
                    if (execJvmArgs != null) {
                        jvmArgs.addAll(execJvmArgs);
                    }
                    jvmArgs.addAll(javaFXModuleJvmArgs);
                    this.execTask.setJvmArgs(jvmArgs);
                }
            }
        } else {
            throw new GradleException("Run task not found. Please, make sure the Application plugin is applied");
        }
    }

    private static boolean isJavaFXJar(File jar, String version, JavaFXPlatform platform) {
        return jar.isFile() && Arrays.stream(JavaFXModule.values()).anyMatch(javaFXModule -> javaFXModule.getPlatformJarFileName(version, platform).equals(jar.getName()) || javaFXModule.getModuleJarFileName().equals(jar.getName()));
    }
}

