/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import org.openjdk.jol.Operation;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.X86_32_DataModel;
import org.openjdk.jol.datamodel.X86_64_COOPS_DataModel;
import org.openjdk.jol.datamodel.X86_64_DataModel;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;

public class ObjectEstimates
implements Operation {
    @Override
    public String label() {
        return "estimates";
    }

    @Override
    public String description() {
        return "Simulate the class layout in different VM modes.";
    }

    @Override
    public void run(String ... args) throws Exception {
        if (args.length == 0) {
            System.err.println("Expected one or more class names.");
            return;
        }
        for (String klassName : args) {
            try {
                Class<?> klass = Class.forName(klassName);
                System.out.println("***** 32-bit VM: **********************************************************");
                System.out.println(ClassLayout.parseClass(klass, (Layouter)new HotSpotLayouter((DataModel)new X86_32_DataModel(), false, false, false)).toPrintable());
                System.out.println("***** 64-bit VM: **********************************************************");
                System.out.println(ClassLayout.parseClass(klass, (Layouter)new HotSpotLayouter((DataModel)new X86_64_DataModel(), false, false, false)).toPrintable());
                System.out.println("***** 64-bit VM, compressed references enabled: ***************************");
                System.out.println(ClassLayout.parseClass(klass, (Layouter)new HotSpotLayouter((DataModel)new X86_64_COOPS_DataModel(), false, false, false)).toPrintable());
                System.out.println("***** 64-bit VM, compressed references enabled, 16-byte align: ************");
                System.out.println(ClassLayout.parseClass(klass, (Layouter)new HotSpotLayouter((DataModel)new X86_64_COOPS_DataModel(16), false, false, false)).toPrintable());
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }
}

