/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.X86_32_DataModel;
import org.openjdk.jol.datamodel.X86_64_COOPS_DataModel;
import org.openjdk.jol.datamodel.X86_64_DataModel;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.layouters.Layouter;

public class MainObjectEstimates {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: jol-estimates.jar [class-name]*");
            System.exit(1);
        }
        for (String klassName : args) {
            try {
                Class<?> klass = Class.forName(klassName);
                System.out.println("***** 32-bit VM: **********************************************************");
                System.out.println(ClassLayout.parseClass(klass, (Layouter)new HotSpotLayouter((DataModel)new X86_32_DataModel(), false, false, false)).toPrintable());
                System.out.println("***** 64-bit VM: **********************************************************");
                System.out.println(ClassLayout.parseClass(klass, (Layouter)new HotSpotLayouter((DataModel)new X86_64_DataModel(), false, false, false)).toPrintable());
                System.out.println("***** 64-bit VM, compressed references enabled: ***************************");
                System.out.println(ClassLayout.parseClass(klass, (Layouter)new HotSpotLayouter((DataModel)new X86_64_COOPS_DataModel(), false, false, false)).toPrintable());
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }
}

