/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.openjdk.jol.Operation;
import org.openjdk.jol.datamodel.CurrentDataModel;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.heap.HeapDumpReader;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.util.Multiset;

public class HeapDumpStats
implements Operation {
    @Override
    public String label() {
        return "heapdumpstats";
    }

    @Override
    public String description() {
        return "Consume the heap dump and print the most frequent instances.";
    }

    @Override
    public void run(String ... args) throws Exception {
        if (args.length == 0) {
            System.err.println("Expected a hprof file name.");
            return;
        }
        String path = args[0];
        System.out.println("Heap Dump: " + path);
        HeapDumpReader reader = new HeapDumpReader(new File(path));
        Multiset data = reader.parse();
        Multiset counts = new Multiset();
        final Multiset sizes = new Multiset();
        HotSpotLayouter layouter = new HotSpotLayouter((DataModel)new CurrentDataModel());
        for (ClassData cd : data.keys()) {
            long size = layouter.layout(cd).instanceSize();
            counts.add((Object)cd.name(), data.count((Object)cd));
            sizes.add((Object)cd.name(), data.count((Object)cd) * size);
        }
        ArrayList sorted = new ArrayList();
        sorted.addAll(sizes.keys());
        Collections.sort(sorted, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return Long.valueOf(sizes.count((Object)o2)).compareTo(sizes.count((Object)o1));
            }
        });
        int printFirst = Integer.getInteger("printFirst", 30);
        int idx = 0;
        System.out.printf(" %10s %10s %10s   %s%n", "COUNT", "AVG", "SIZE", "DESCRIPTION");
        System.out.println("-------------------------------------------------------------------------");
        for (String name : sorted) {
            if (++idx > printFirst) break;
            long cnt = counts.count((Object)name);
            long size = sizes.count((Object)name);
            System.out.printf(" %10d %10d %10d   %s%n", cnt, size / cnt, size, name);
        }
        System.out.println("-------------------------------------------------------------------------");
        System.out.printf(" %10d %10s %10d   %s%n", counts.size(), "", sizes.size(), "(total)");
    }
}

