/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.test.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.openjdk.jmc.common.io.IOToolkit;
import org.openjdk.jmc.test.io.FileResource;
import org.openjdk.jmc.test.io.IOResource;
import org.openjdk.jmc.test.io.JarFileResource;

public final class IOResourceSet
implements Iterable<IOResource> {
    private final List<IOResource> m_resources;

    public IOResourceSet(IOResource ... resources) {
        this.m_resources = Arrays.asList(resources);
    }

    public IOResourceSet(List<IOResource> resources) {
        this.m_resources = resources;
    }

    public List<IOResource> getResources() {
        return this.m_resources;
    }

    public IOResource getResource(int index) {
        return this.m_resources.get(index);
    }

    @Override
    public Iterator<IOResource> iterator() {
        return this.m_resources.iterator();
    }

    public IOResource findWithPrefix(String namePrefix) {
        for (IOResource file : this.m_resources) {
            if (!file.getName().startsWith(namePrefix)) continue;
            return file;
        }
        return null;
    }

    public static IOResourceSet createResourceSet(File file) throws IOException {
        if (file.isDirectory()) {
            return IOResourceSet.createResourceSetFromDirectory(file);
        }
        if (IOToolkit.isZipFile((File)file)) {
            return IOResourceSet.createResourceSetFromJarFile(file);
        }
        return null;
    }

    private static IOResourceSet createResourceSetFromJarFile(File file) throws IOException {
        ArrayList<IOResource> resources = new ArrayList<IOResource>();
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> files = jarFile.entries();
        while (files.hasMoreElements()) {
            JarEntry je = files.nextElement();
            resources.add(new JarFileResource(jarFile, je));
        }
        return new IOResourceSet(resources);
    }

    private static IOResourceSet createResourceSetFromDirectory(File directory) {
        ArrayList<IOResource> resources = new ArrayList<IOResource>();
        for (File file : directory.listFiles()) {
            resources.add(new FileResource(file));
        }
        return new IOResourceSet(resources);
    }
}

