/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.schema;

import java.net.URL;

public final class SchemaResolver {
    private static final Schema[] schemas = new Schema[]{new Schema("http://www.w3.org/2001/XMLSchema", null, "xmlschema/XMLSchema.xsd"), new Schema("http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/xml.xsd", "xmlschema/xml.xsd")};

    public static URL resolve(String publicId, String systemId) {
        if (publicId == null) {
            return null;
        }
        for (Schema schema : schemas) {
            if (!publicId.equals(schema.publicId)) continue;
            if (schema.url != null) {
                return schema.url;
            }
            URL url = Thread.currentThread().getContextClassLoader().getResource(schema.resourcePath);
            if (url == null) {
                throw new IllegalStateException("Unable to find location of schema: " + schema);
            }
            return schema.url = url;
        }
        return null;
    }

    private SchemaResolver() {
    }

    private static class Schema {
        private final String publicId;
        private final String systemId;
        private final String resourcePath;
        private URL url;

        private Schema(String publicId, String systemId, String resourcePath) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.resourcePath = resourcePath;
        }

        public String toString() {
            return "{" + this.publicId + "}" + this.systemId;
        }
    }
}

