/*
 * Decompiled with CFR 0.152.
 */
package org.openjax.xml.api;

public final class CharacterDatas {
    private static void assertQuote(char quote) {
        if (quote != '\"' && quote != '\'') {
            throw new IllegalArgumentException("Illegal quote character: " + quote);
        }
    }

    private static void assertRange(int off, int len, CharSequence str) {
        CharacterDatas.assertRange(off, len, str.length(), "str.length()");
    }

    private static void assertRange(int off, int len, char[] chars) {
        CharacterDatas.assertRange(off, len, chars.length, "chars.length");
    }

    private static void assertRange(int off, int len, int length, String lenError) {
        if (off < 0) {
            throw new IndexOutOfBoundsException("off (" + off + ") must be non-negative");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len (" + len + ") must be non-negative");
        }
        if (off + len > length) {
            throw new IndexOutOfBoundsException("off (" + off + ") + len (" + len + ") > " + lenError + " (" + length + ")");
        }
    }

    private static StringBuilder escape(StringBuilder out, CharSequence str, char quote, int off, int len) {
        int length = off + len;
        for (int i = off; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                out.append("&amp;");
                continue;
            }
            if (ch == '>') {
                out.append("&gt;");
                continue;
            }
            if (ch == '<') {
                out.append("&lt;");
                continue;
            }
            if (quote != ch) {
                out.append(ch);
                continue;
            }
            if (ch == '\'') {
                out.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                out.append("&quot;");
                continue;
            }
            throw new IllegalArgumentException("Illegal quote character: '" + quote + "'");
        }
        return out;
    }

    private static StringBuilder escape(StringBuilder out, char[] chars, char quote, int off, int len) {
        int length = off + len;
        for (int i = off; i < length; ++i) {
            char ch = chars[i];
            if (ch == '&') {
                out.append("&amp;");
                continue;
            }
            if (ch == '>') {
                out.append("&gt;");
                continue;
            }
            if (ch == '<') {
                out.append("&lt;");
                continue;
            }
            if (quote != ch) {
                out.append(ch);
                continue;
            }
            if (ch == '\'') {
                out.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                out.append("&quot;");
                continue;
            }
            throw new IllegalArgumentException("Illegal quote character: '" + quote + "'");
        }
        return out;
    }

    public static StringBuilder escapeForAttr(CharSequence str, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(new StringBuilder(), str, quote, 0, str.length());
    }

    public static StringBuilder escapeForAttr(StringBuilder out, CharSequence str, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(out, str, quote, 0, str.length());
    }

    public static StringBuilder escapeForAttr(char[] chars, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(new StringBuilder(), chars, quote, 0, chars.length);
    }

    public static StringBuilder escapeForAttr(StringBuilder out, char[] chars, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(out, chars, quote, 0, chars.length);
    }

    public static StringBuilder escapeForAttr(CharSequence str, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(new StringBuilder(), str, quote, off, len);
    }

    public static StringBuilder escapeForAttr(StringBuilder out, CharSequence str, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(out, str, quote, off, len);
    }

    public static StringBuilder escapeForAttr(char[] chars, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(new StringBuilder(), chars, quote, off, len);
    }

    public static StringBuilder escapeForAttr(StringBuilder out, char[] chars, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.escape(out, chars, quote, off, len);
    }

    public static StringBuilder escapeForElem(CharSequence str) {
        return CharacterDatas.escape(new StringBuilder(), str, '\u0000', 0, str.length());
    }

    public static StringBuilder escapeForElem(StringBuilder out, CharSequence str) {
        return CharacterDatas.escape(out, str, '\u0000', 0, str.length());
    }

    public static StringBuilder escapeForElem(char[] chars) {
        return CharacterDatas.escape(new StringBuilder(), chars, '\u0000', 0, chars.length);
    }

    public static StringBuilder escapeForElem(StringBuilder out, char[] chars) {
        return CharacterDatas.escape(out, chars, '\u0000', 0, chars.length);
    }

    public static StringBuilder escapeForElem(CharSequence str, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        return CharacterDatas.escape(new StringBuilder(), str, '\u0000', off, len);
    }

    public static StringBuilder escapeForElem(StringBuilder out, CharSequence str, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        return CharacterDatas.escape(out, str, '\u0000', off, len);
    }

    public static StringBuilder escapeForElem(char[] chars, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        return CharacterDatas.escape(new StringBuilder(), chars, '\u0000', off, len);
    }

    public static StringBuilder escapeForElem(StringBuilder out, char[] chars, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        return CharacterDatas.escape(out, chars, '\u0000', off, len);
    }

    private static int check(char c5, char c4, char c3, char c2, char c1, char c0, StringBuilder out, int i) {
        if (i >= 0) {
            return i;
        }
        if (c5 != '\u0000') {
            out.append(c5);
        }
        if (c4 != '\u0000') {
            out.append(c4);
        }
        if (c3 != '\u0000') {
            out.append(c3);
        }
        if (c2 != '\u0000') {
            out.append(c2);
        }
        if (c1 != '\u0000') {
            out.append(c1);
        }
        if (c0 != '\u0000') {
            out.append(c0);
        }
        return -i;
    }

    private static int unescape(StringBuilder out, CharSequence str, int i, char c4, char c3, char c2, char c1, int depth, char quote, int len) {
        if (i == len) {
            return -i;
        }
        char c0 = str.charAt(i);
        if (c0 == '&') {
            return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : str.charAt(i), out, CharacterDatas.unescape(out, str, i, c3, c2, c1, c0, 1, quote, len));
        }
        if (depth == 1) {
            if (c0 == 'a' || c0 == 'g' || c0 == 'l' || c0 == 'q') {
                return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : str.charAt(i), out, CharacterDatas.unescape(out, str, i, c3, c2, c1, c0, 2, quote, len));
            }
            return -i;
        }
        if (depth == 2) {
            if (c0 == 'm' || c0 == 'p' || c0 == 't' || c0 == 'u') {
                return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : str.charAt(i), out, CharacterDatas.unescape(out, str, i, c3, c2, c1, c0, 3, quote, len));
            }
            return -i;
        }
        if (depth == 3) {
            if (c0 == 'p' || c0 == 'o') {
                return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : str.charAt(i), out, CharacterDatas.unescape(out, str, i, c3, c2, c1, c0, 4, quote, len));
            }
            if (c0 == ';' && c1 == 't') {
                if (c2 == 'g') {
                    out.append('>');
                    return i;
                }
                if (c2 == 'l') {
                    out.append('<');
                    return i;
                }
            }
            return -i;
        }
        if (depth == 4) {
            if (c0 == 's') {
                return quote != '\'' ? -i : CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : str.charAt(i), out, CharacterDatas.unescape(out, str, i, c3, c2, c1, c0, 5, quote, len));
            }
            if (c0 == 't') {
                return quote != '\"' ? -i : CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : str.charAt(i), out, CharacterDatas.unescape(out, str, i, c3, c2, c1, c0, 5, quote, len));
            }
            if (c0 == ';' && c1 == 'p') {
                out.append('&');
                return i;
            }
            return -i;
        }
        if (depth == 5 && c0 == ';') {
            if (c1 == 's') {
                out.append('\'');
                return i;
            }
            if (c1 == 't') {
                out.append('\"');
                return i;
            }
            return -i;
        }
        out.append(c0);
        return i;
    }

    private static int unescape(StringBuilder out, char[] chars, int i, char c4, char c3, char c2, char c1, int depth, char quote, int len) {
        if (i == len) {
            return -i;
        }
        char c0 = chars[i];
        if (c0 == '&') {
            return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : chars[i], out, CharacterDatas.unescape(out, chars, i, c3, c2, c1, c0, 1, quote, len));
        }
        if (depth == 1 && (c0 == 'a' || c0 == 'g' || c0 == 'l' || c0 == 'q')) {
            return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : chars[i], out, CharacterDatas.unescape(out, chars, i, c3, c2, c1, c0, 2, quote, len));
        }
        if (depth == 2 && (c0 == 'm' || c0 == 'p' || c0 == 't' || c0 == 'u')) {
            return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : chars[i], out, CharacterDatas.unescape(out, chars, i, c3, c2, c1, c0, 3, quote, len));
        }
        if (depth == 3) {
            if (c0 == 'p' || c0 == 'o') {
                return CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : chars[i], out, CharacterDatas.unescape(out, chars, i, c3, c2, c1, c0, 4, quote, len));
            }
            if (c0 == ';' && c1 == 't') {
                if (c2 == 'g') {
                    out.append('>');
                    return i;
                }
                if (c2 == 'l') {
                    out.append('<');
                    return i;
                }
                return -i;
            }
        } else {
            if (depth == 4) {
                if (c0 == 's') {
                    return quote != '\'' ? -i : CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : chars[i], out, CharacterDatas.unescape(out, chars, i, c3, c2, c1, c0, 5, quote, len));
                }
                if (c0 == 't') {
                    return quote != '\"' ? -i : CharacterDatas.check(c4, c3, c2, c1, c0, ++i == len ? (char)'\u0000' : chars[i], out, CharacterDatas.unescape(out, chars, i, c3, c2, c1, c0, 5, quote, len));
                }
                if (c0 == ';' && c1 == 'p') {
                    out.append('&');
                    return i;
                }
                return -i;
            }
            if (depth == 5 && c0 == ';') {
                if (c1 == 's') {
                    out.append('\'');
                    return i;
                }
                if (c1 == 't') {
                    out.append('\"');
                    return i;
                }
                return -i;
            }
        }
        out.append(c0);
        return i;
    }

    private static StringBuilder unescape(StringBuilder out, CharSequence str, char quote, int off, int len) {
        int length = off + len;
        for (int i = off; i < length; ++i) {
            i = CharacterDatas.unescape(out, str, i, '\u0000', '\u0000', '\u0000', '\u0000', 0, quote, length);
        }
        return out;
    }

    private static StringBuilder unescape(StringBuilder out, char[] chars, char quote, int off, int len) {
        int length = off + len;
        for (int i = off; i < length; ++i) {
            i = CharacterDatas.unescape(out, chars, i, '\u0000', '\u0000', '\u0000', '\u0000', 0, quote, length);
        }
        return out;
    }

    public static StringBuilder unescapeFromAttr(CharSequence str, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.unescape(new StringBuilder(), str, quote, 0, str.length());
    }

    public static StringBuilder unescapeFromAttr(StringBuilder out, CharSequence str, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.unescape(out, str, quote, 0, str.length());
    }

    public static StringBuilder unescapeFromAttr(char[] chars, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.unescape(new StringBuilder(), chars, quote, 0, chars.length);
    }

    public static StringBuilder unescapeFromAttr(StringBuilder out, char[] chars, char quote) {
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.unescape(out, chars, quote, 0, chars.length);
    }

    public static StringBuilder unescapeFromAttr(CharSequence str, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        return CharacterDatas.unescape(new StringBuilder(), str, quote, off, len);
    }

    public static StringBuilder unescapeFromAttr(StringBuilder out, CharSequence str, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.unescape(out, str, quote, off, len);
    }

    public static StringBuilder unescapeFromAttr(char[] chars, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.unescape(new StringBuilder(), chars, quote, off, len);
    }

    public static StringBuilder unescapeFromAttr(StringBuilder out, char[] chars, char quote, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        CharacterDatas.assertQuote(quote);
        return CharacterDatas.unescape(out, chars, quote, off, len);
    }

    public static StringBuilder unescapeFromElem(CharSequence str) {
        return CharacterDatas.unescape(new StringBuilder(), str, '\u0000', 0, str.length());
    }

    public static StringBuilder unescapeFromElem(StringBuilder out, CharSequence str) {
        return CharacterDatas.unescape(out, str, '\u0000', 0, str.length());
    }

    public static StringBuilder unescapeFromElem(char[] chars) {
        return CharacterDatas.unescape(new StringBuilder(), chars, '\u0000', 0, chars.length);
    }

    public static StringBuilder unescapeFromElem(StringBuilder out, char[] chars) {
        return CharacterDatas.unescape(out, chars, '\u0000', 0, chars.length);
    }

    public static StringBuilder unescapeFromElem(CharSequence str, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        return CharacterDatas.unescape(new StringBuilder(), str, '\u0000', off, len);
    }

    public static StringBuilder unescapeFromElem(StringBuilder out, CharSequence str, int off, int len) {
        CharacterDatas.assertRange(off, len, str);
        return CharacterDatas.unescape(out, str, '\u0000', off, len);
    }

    public static StringBuilder unescapeFromElem(char[] chars, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        return CharacterDatas.unescape(new StringBuilder(), chars, '\u0000', off, len);
    }

    public static StringBuilder unescapeFromElem(StringBuilder out, char[] chars, int off, int len) {
        CharacterDatas.assertRange(off, len, chars);
        return CharacterDatas.unescape(out, chars, '\u0000', off, len);
    }

    private CharacterDatas() {
    }
}

