/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.tools.web;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.openimaj.image.Image;
import org.openimaj.image.ImageUtilities;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.RGBColour;
import org.openimaj.image.processing.resize.ResizeProcessor;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.web.layout.ElementInfo;
import org.openimaj.web.layout.LayoutExtractor;

public class LayoutExtractorTool {
    private static final int THUMBNAIL_HEIGHT = 100;
    private static final int THUMBNAIL_WIDTH = 100;
    private static final Float[] NON_CONTENT_COLOUR = RGBColour.CYAN;
    private static final Float[] NON_CONTENT_INSIDE_COLOUR = RGBColour.RED;
    private static final Float[] CONTENT_COLOUR = RGBColour.GREEN;
    @Option(name="--thumbnail", aliases={"-t"}, usage="Write a thumbnail image of the page", required=false)
    File thumbnailFile;
    @Option(name="--render", aliases={"-r"}, usage="Write a rendered image of the page", required=false)
    File renderFile;
    @Option(name="--layout", aliases={"-l"}, usage="Write the layout information in CSV format. Passing \"-\" will cause the data to be written to STDOUT", required=false)
    File layoutFile;
    @Option(name="--layout-render", aliases={"-lr"}, usage="Write the layout information as an image", required=false)
    File layoutRender;
    @Option(name="--layout-render-overlay", aliases={"-lro"}, usage="Write the layout information as an image, overlayed on a render of the page", required=false)
    File layoutRenderOverlayed;
    @Option(name="--content-layout-render", aliases={"-clr"}, usage="Write the content layout information as an image", required=false)
    File contentLayoutRender;
    @Option(name="--content-layout-render-overlay", aliases={"-clro"}, usage="Write the content layout information as an image, overlayed on a render of the page", required=false)
    File contentLayoutRenderOverlayed;
    @Argument
    String url;
    LayoutExtractor extractor = new LayoutExtractor();
    MBFImage render;

    protected void writeLayout() throws IOException {
        List info = this.extractor.getLayoutInfo();
        PrintWriter pw = this.layoutFile.getName().equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(this.layoutFile));
        pw.println(ElementInfo.getCSVHeader());
        for (ElementInfo ei : info) {
            pw.println(ei.toCSVString());
        }
        if (!this.layoutFile.getName().equals("-")) {
            pw.close();
        }
    }

    protected MBFImage getRender() {
        if (this.render == null) {
            this.render = this.extractor.render();
        }
        return this.render;
    }

    public void extractContent() throws IOException {
        if (!this.extractor.load(this.url)) {
            System.err.println("Error loading page: " + this.url);
            System.exit(1);
        }
        if (this.layoutFile != null) {
            this.writeLayout();
        }
        if (this.thumbnailFile != null) {
            MBFImage image = this.getRender();
            if ((double)image.getHeight() > 1.5 * (double)image.getWidth()) {
                image = (MBFImage)image.extractROI(0, 0, image.getWidth(), image.getWidth());
            }
            MBFImage thumb = (MBFImage)image.process((SinglebandImageProcessor)new ResizeProcessor(100.0f, 100.0f));
            ImageUtilities.write((Image)thumb, (File)this.thumbnailFile);
        }
        if (this.renderFile != null) {
            ImageUtilities.write((Image)this.getRender(), (File)this.renderFile);
        }
        if (this.layoutRender != null) {
            ImageUtilities.write((Image)this.extractor.renderLayoutInfo(RGBColour.BLACK), (File)this.layoutRender);
        }
        if (this.layoutRenderOverlayed != null) {
            ImageUtilities.write((Image)this.extractor.renderLayoutInfo(this.getRender(), RGBColour.RED), (File)this.layoutRenderOverlayed);
        }
        if (this.contentLayoutRender != null) {
            ImageUtilities.write((Image)this.extractor.renderContentLayout(CONTENT_COLOUR, NON_CONTENT_INSIDE_COLOUR, NON_CONTENT_COLOUR), (File)this.contentLayoutRender);
        }
        if (this.contentLayoutRenderOverlayed != null) {
            ImageUtilities.write((Image)this.extractor.renderContentLayout(this.getRender(), CONTENT_COLOUR, NON_CONTENT_INSIDE_COLOUR, NON_CONTENT_COLOUR), (File)this.contentLayoutRenderOverlayed);
        }
    }

    public static void main(String[] args) throws IOException {
        System.setOut(new PrintStream((OutputStream)System.out, true, "UTF-8"));
        LayoutExtractorTool extractor = new LayoutExtractorTool();
        CmdLineParser parser = new CmdLineParser((Object)extractor);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Usage: java -jar LayoutExtractor.jar [options...]");
            parser.printUsage((OutputStream)System.err);
            return;
        }
        extractor.extractContent();
    }
}

