/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.textpipe.annotators;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;
import org.openimaj.text.nlp.textpipe.annotations.AnnotationUtils;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.SentenceAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.AbstractNEAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;

public class OpenNLPPersonAnnotator
extends AbstractNEAnnotator {
    public static final String PERSON_MODEL_PROP = "org.openimaj.text.opennlp.models.person";
    NameFinderME nameFinder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenNLPPersonAnnotator() {
        TokenNameFinderModel model = null;
        String resourceLocation = System.getProperty(PERSON_MODEL_PROP);
        InputStream modelIn = OpenNLPPersonAnnotator.class.getResourceAsStream(resourceLocation);
        try {
            model = new TokenNameFinderModel(modelIn);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (modelIn != null) {
                try {
                    modelIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.nameFinder = new NameFinderME(model);
    }

    @Override
    void performAnnotation(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
        for (SentenceAnnotation sentence : annotation.getAnnotationsFor(SentenceAnnotation.class)) {
            Span[] nameSpans;
            List<TokenAnnotation> atoks = sentence.getAnnotationsFor(TokenAnnotation.class);
            List<String> toks = AnnotationUtils.getStringTokensFromTokenAnnotationList(atoks);
            for (Span s : nameSpans = this.nameFinder.find(AnnotationUtils.ListToArray(toks))) {
                for (int i = s.getStart(); i < s.getEnd(); ++i) {
                    atoks.get(i).addAnnotation(annotation);
                }
            }
        }
        this.nameFinder.clearAdaptiveData();
    }

    @Override
    void checkForRequiredAnnotations(RawTextAnnotation annotation) throws MissingRequiredAnnotationException {
    }
}

