/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.type;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.procedure.TObjectIntProcedure;
import java.util.HashMap;
import java.util.Map;
import org.openimaj.text.nlp.sentiment.model.wordlist.util.TFF;
import org.openimaj.text.nlp.sentiment.type.BipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.BipolarSentimentProvider;
import org.openimaj.text.nlp.sentiment.type.DiscreteCountBipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.DiscreteCountBipolarSentimentProvider;
import org.openimaj.text.nlp.sentiment.type.InvalidSentimentException;
import org.openimaj.text.nlp.sentiment.type.Sentiment;
import org.openimaj.text.nlp.sentiment.type.UnrecognisedMapException;
import org.openimaj.text.nlp.sentiment.type.WeightedBipolarSentiment;
import org.openimaj.text.nlp.sentiment.type.WeightedBipolarSentimentProvider;

public class TFFCountSentiment
implements Sentiment,
BipolarSentimentProvider,
WeightedBipolarSentimentProvider,
DiscreteCountBipolarSentimentProvider {
    private TObjectIntHashMap<TFF.Polarity> sentiments = new TObjectIntHashMap();
    private int total;

    public TFFCountSentiment() {
        for (TFF.Polarity polarity : TFF.Polarity.values()) {
            this.sentiments.put((Object)polarity, 0);
        }
    }

    public TFFCountSentiment(int total) {
        this();
        this.total = total;
    }

    public void incrementClue(TFF.Clue entry, int increment) {
        this.sentiments.adjustOrPutValue((Object)entry.polarity, increment, increment);
    }

    @Override
    public BipolarSentiment bipolar() {
        BipolarTFFPolarityIterator instance = new BipolarTFFPolarityIterator();
        this.sentiments.forEachEntry((TObjectIntProcedure)instance);
        if (instance.positive > instance.negative) {
            if (instance.positive > instance.neutral) {
                return BipolarSentiment.POSITIVE;
            }
            return BipolarSentiment.NEUTRAL;
        }
        if (instance.negative > instance.neutral) {
            return BipolarSentiment.NEGATIVE;
        }
        return BipolarSentiment.NEUTRAL;
    }

    @Override
    public BipolarSentiment bipolar(double deltaThresh) {
        BipolarTFFPolarityIterator instance = new BipolarTFFPolarityIterator();
        this.sentiments.forEachEntry((TObjectIntProcedure)instance);
        if ((double)instance.positive > (double)instance.negative * deltaThresh) {
            if ((double)instance.positive > (double)instance.neutral * deltaThresh) {
                return BipolarSentiment.POSITIVE;
            }
            if ((double)instance.neutral > (double)instance.positive * deltaThresh) {
                return BipolarSentiment.NEUTRAL;
            }
        } else {
            if ((double)instance.negative > (double)instance.neutral * deltaThresh) {
                return BipolarSentiment.NEGATIVE;
            }
            if ((double)instance.neutral > (double)instance.negative * deltaThresh) {
                return BipolarSentiment.NEUTRAL;
            }
        }
        return null;
    }

    @Override
    public WeightedBipolarSentiment weightedBipolar() {
        BipolarTFFPolarityIterator instance = new BipolarTFFPolarityIterator();
        this.sentiments.forEachEntry((TObjectIntProcedure)instance);
        return new WeightedBipolarSentiment((double)instance.positive / (double)this.total, (double)instance.negative / (double)this.total, (double)instance.neutral / (double)this.total);
    }

    @Override
    public DiscreteCountBipolarSentiment countBipolarSentiment() {
        BipolarTFFPolarityIterator instance = new BipolarTFFPolarityIterator();
        this.sentiments.forEachEntry((TObjectIntProcedure)instance);
        try {
            return new DiscreteCountBipolarSentiment(instance.positive, instance.negative, instance.neutral, this.total);
        }
        catch (InvalidSentimentException e) {
            return null;
        }
    }

    @Override
    public Map<String, ?> asMap() {
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (TFF.Polarity polarity : TFF.Polarity.values()) {
            ret.put(polarity.name(), this.sentiments.get((Object)polarity));
        }
        ret.put("total", this.total);
        return ret;
    }

    @Override
    public void fromMap(Map<String, ?> map) throws UnrecognisedMapException {
        for (TFF.Polarity polarity : TFF.Polarity.values()) {
            Object value = map.get(polarity.name());
            if (value == null) {
                throw new UnrecognisedMapException(new String[]{"Could not find polarity: " + (Object)((Object)polarity)});
            }
            this.sentiments.put((Object)polarity, ((Integer)value).intValue());
        }
        if (!map.containsKey("total")) {
            throw new UnrecognisedMapException(new String[]{"Could not find total"});
        }
        this.total = (Integer)map.get("total");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TFFCountSentiment)) {
            return false;
        }
        TFFCountSentiment that = (TFFCountSentiment)obj;
        if (this.total != that.total) {
            return false;
        }
        for (Object clue : this.sentiments.keys()) {
            if (this.sentiments.get(clue) == that.sentiments.get(clue)) continue;
            return false;
        }
        return true;
    }

    public static BipolarSentiment bipolar(TFF.Clue clue) {
        TFFCountSentiment count = new TFFCountSentiment(1);
        count.incrementClue(clue, 1);
        return count.bipolar();
    }

    private static final class BipolarTFFPolarityIterator
    implements TObjectIntProcedure<TFF.Polarity> {
        public int negative = 0;
        public int neutral = 0;
        public int positive = 0;

        private BipolarTFFPolarityIterator() {
        }

        public boolean execute(TFF.Polarity a, int b) {
            if (a.equals((Object)TFF.Polarity.positive) || a.equals((Object)TFF.Polarity.strongpos) || a.equals((Object)TFF.Polarity.weakpos)) {
                this.positive += b;
            } else if (a.equals((Object)TFF.Polarity.both)) {
                this.positive += b;
                this.negative += b;
            } else if (a.equals((Object)TFF.Polarity.neutral)) {
                this.neutral += b;
            } else {
                this.negative += b;
            }
            return true;
        }
    }
}

