/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.type;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openimaj.text.nlp.sentiment.type.Sentiment;
import org.openimaj.text.nlp.sentiment.type.UnrecognisedMapException;

public class BipolarSentiment
implements Sentiment {
    public static final BipolarSentiment NEUTRAL = new BipolarSentiment(State.NEUTRAL);
    public static final BipolarSentiment NEGATIVE = new BipolarSentiment(State.NEGATIVE);
    public static final BipolarSentiment POSITIVE = new BipolarSentiment(State.POSITIVE);
    private State state;

    public BipolarSentiment() {
        this(State.NEUTRAL);
    }

    public BipolarSentiment(State positive) {
        this.state = positive;
    }

    public boolean negative() {
        return this.state == State.NEGATIVE;
    }

    public boolean positive() {
        return this.state == State.POSITIVE;
    }

    public boolean neutral() {
        return this.state == State.NEUTRAL;
    }

    public State sentiment() {
        return this.state;
    }

    @Override
    public Map<String, ?> asMap() {
        HashMap<String, State> ret = new HashMap<String, State>();
        ret.put("state", this.state);
        return ret;
    }

    @Override
    public void fromMap(Map<String, ?> map) throws UnrecognisedMapException {
        if (!map.containsKey("state")) {
            throw new UnrecognisedMapException(new String[]{"state"});
        }
        this.state = (State)((Object)map.get("state"));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BipolarSentiment)) {
            return false;
        }
        BipolarSentiment that = (BipolarSentiment)obj;
        return that.state == this.state;
    }

    public String toString() {
        return this.state.name();
    }

    public static Set<BipolarSentiment> listBipolarSentiment() {
        HashSet<BipolarSentiment> ret = new HashSet<BipolarSentiment>();
        ret.add(POSITIVE);
        ret.add(NEUTRAL);
        ret.add(NEGATIVE);
        return ret;
    }

    public static enum State {
        POSITIVE,
        NEGATIVE,
        NEUTRAL;

    }
}

