/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.model.classifier;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.feature.DoubleFV;
import org.openimaj.feature.FeatureExtractor;

public class GeneralSentimentFeatureExtractor
implements FeatureExtractor<DoubleFV, List<String>> {
    private ArrayList<String> vocabList;
    private int wordOccuranceThresh = 50;

    public GeneralSentimentFeatureExtractor(List<List<String>> domainVocabularyCorpus) {
        this.initialize(domainVocabularyCorpus);
    }

    public GeneralSentimentFeatureExtractor() {
    }

    public void initialize(List<List<String>> domainVocabularyCorpus) {
        HashMap<String, Integer> vocab = new HashMap<String, Integer>();
        for (List<String> list : domainVocabularyCorpus) {
            for (String s : list) {
                Integer current = (Integer)vocab.get(s);
                if (current == null) {
                    current = 0;
                }
                vocab.put(s, current + 1);
            }
        }
        this.vocabList = new ArrayList();
        for (Map.Entry entry : vocab.entrySet()) {
            if ((Integer)entry.getValue() <= this.wordOccuranceThresh) continue;
            this.vocabList.add((String)entry.getKey());
        }
    }

    public DoubleFV extractFeature(List<String> tokens) {
        double[] vect = new double[this.vocabList.size()];
        int i = 0;
        while (i < vect.length) {
            int n = i++;
            vect[n] = vect[n] + 1.0E-5;
        }
        for (String s : tokens) {
            int ind = this.vocabList.indexOf(s);
            if (ind < 0) continue;
            int n = ind;
            vect[n] = vect[n] + 1.0;
        }
        double[] vectNorm = new double[this.vocabList.size()];
        for (int i2 = 0; i2 < vect.length; ++i2) {
            vectNorm[i2] = vect[i2] / (double)tokens.size();
        }
        return new DoubleFV(vect);
    }
}

