/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.sentiment.lexicon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openimaj.ml.clustering.assignment.HardAssigner;
import org.openimaj.ml.clustering.kmeans.DoubleKMeans;
import org.openimaj.text.nlp.textpipe.annotations.POSAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.RawTextAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.SentenceAnnotation;
import org.openimaj.text.nlp.textpipe.annotations.TokenAnnotation;
import org.openimaj.text.nlp.textpipe.annotators.MissingRequiredAnnotationException;
import org.openimaj.text.nlp.textpipe.annotators.OpenNLPPOSAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.OpenNLPSentenceAnnotator;
import org.openimaj.text.nlp.textpipe.annotators.OpenNLPTokenAnnotator;

public class TotalLexBuilder {
    private HashMap<String, double[]> vectors;
    private HashMap<String, Integer> assignments;
    private List<String> posConfirmation;
    private List<String> negConfirmation;
    private OpenNLPTokenAnnotator tokA;
    private OpenNLPPOSAnnotator posA;
    private OpenNLPSentenceAnnotator sentA;
    private HashMap<String, List<HashMap<String, Counter>>> counts;
    private int AND = 0;
    private int BUT = 1;

    public TotalLexBuilder(List<String> posConfirmation, List<String> negConfirmation) {
        this.posConfirmation = posConfirmation;
        this.negConfirmation = negConfirmation;
        this.tokA = new OpenNLPTokenAnnotator();
        this.posA = new OpenNLPPOSAnnotator();
        this.sentA = new OpenNLPSentenceAnnotator();
        this.counts = new HashMap();
    }

    public Map<String, Double> build(List<String> corpus) {
        for (String doc : corpus) {
            this.getAdjectiveConjunctions(doc, " and ");
            this.getAdjectiveConjunctions(doc, " but ");
        }
        this.buildVectors();
        this.normaliseVectors();
        this.cluster();
        return null;
    }

    private void cluster() {
        DoubleKMeans fkm = DoubleKMeans.createExact((int)this.counts.keySet().size(), (int)2);
        double[][] data = new double[this.counts.keySet().size()][];
        int i = 0;
        for (double[] ds : this.vectors.values()) {
            data[i] = ds;
            ++i;
        }
        DoubleKMeans.Result cluster = fkm.cluster((double[][])data);
        HardAssigner assigner = cluster.defaultHardAssigner();
        this.assignments = new HashMap();
        for (String adj : this.vectors.keySet()) {
            this.assignments.put(adj, assigner.assign((Object)this.vectors.get(adj)));
        }
        for (String adj : this.assignments.keySet()) {
            System.out.println(adj + " " + this.assignments.get(adj));
        }
    }

    private void normaliseVectors() {
    }

    private void buildVectors() {
        this.vectors = new HashMap();
        for (String adj : this.counts.keySet()) {
            this.vectors.put(adj, new double[this.counts.keySet().size() * 2]);
            HashMap<String, Counter> andCount = this.counts.get(adj).get(this.AND);
            HashMap<String, Counter> butCount = this.counts.get(adj).get(this.BUT);
            int i = 0;
            for (String adjInc : this.counts.keySet()) {
                this.vectors.get((Object)adj)[i] = andCount.containsKey(adjInc) ? andCount.get((Object)adjInc).count : 0.0;
                this.vectors.get((Object)adj)[i + this.counts.keySet().size()] = butCount.containsKey(adjInc) ? butCount.get((Object)adjInc).count : 0.0;
                ++i;
            }
        }
    }

    private void getAdjectiveConjunctions(String toSearch, String conjunction) {
        String leftToSearch = toSearch;
        if (leftToSearch.contains(conjunction)) {
            RawTextAnnotation rta = new RawTextAnnotation(toSearch);
            try {
                this.sentA.annotate(rta);
                this.tokA.annotate(rta);
                this.posA.annotate(rta);
            }
            catch (MissingRequiredAnnotationException e) {
                e.printStackTrace();
            }
            List<SentenceAnnotation> sentences = rta.getAnnotationsFor(SentenceAnnotation.class);
            int searchedIndex = 0;
            int sentI = 0;
            while (leftToSearch.contains(conjunction)) {
                int loc = leftToSearch.indexOf(conjunction) + 1 + searchedIndex;
                List<TokenAnnotation> tokens = null;
                int t = 0;
                block3: for (int s = sentI; s < sentences.size(); ++s) {
                    SentenceAnnotation sentence = sentences.get(s);
                    if (sentence.start < loc && sentence.stop > loc) {
                        tokens = sentence.getAnnotationsFor(TokenAnnotation.class);
                        for (t = 0; t < tokens.size(); ++t) {
                            if (tokens.get((int)t).start + sentence.start == loc) break block3;
                        }
                    }
                    ++sentI;
                }
                if (tokens != null) {
                    int c = conjunction.trim().equals("and") ? this.AND : this.BUT;
                    this.checkForConjunctionGroup(tokens, t, c);
                }
                searchedIndex = loc + conjunction.length() - 1;
                leftToSearch = toSearch.substring(searchedIndex);
            }
        }
    }

    private void checkForConjunctionGroup(List<TokenAnnotation> tokens, int conjunctionIndex, int conjunction) {
        if (tokens.size() > conjunctionIndex + 1 && tokens.get((int)(conjunctionIndex - 1)).getAnnotationsFor(POSAnnotation.class).get((int)0).pos.toString().contains("JJ") && tokens.get((int)(conjunctionIndex + 1)).getAnnotationsFor(POSAnnotation.class).get((int)0).pos.toString().contains("JJ")) {
            System.out.println(tokens.get(conjunctionIndex - 1).getStringToken() + " " + tokens.get(conjunctionIndex).getStringToken() + " " + tokens.get(conjunctionIndex + 1).getStringToken());
            ArrayList<String> adjectives = new ArrayList<String>();
            adjectives.add(tokens.get(conjunctionIndex - 1).getStringToken());
            adjectives.add(tokens.get(conjunctionIndex + 1).getStringToken());
            for (int i = 0; i < adjectives.size(); ++i) {
                String vecAdj = (String)adjectives.get(i);
                if (!this.counts.keySet().contains(vecAdj)) {
                    ArrayList cons = new ArrayList();
                    cons.add(new HashMap());
                    cons.add(new HashMap());
                    this.counts.put(vecAdj, cons);
                }
                HashMap<String, Counter> conVector = this.counts.get(vecAdj).get(conjunction);
                for (int j = 0; j < adjectives.size(); ++j) {
                    String incAdj = (String)adjectives.get(j);
                    if (!conVector.containsKey(incAdj)) {
                        conVector.put(incAdj, new Counter());
                        continue;
                    }
                    conVector.get(incAdj).inc();
                }
            }
        }
    }

    public static void main(String[] args) {
        ArrayList<String> pos = new ArrayList<String>();
        ArrayList<String> neg = new ArrayList<String>();
        ArrayList<String> corpus = new ArrayList<String>();
        pos.add("dandy");
        neg.add("horrible");
        corpus.add("Hello, this day is just fine and dandy, I wonder if it is going to turn horrible and sad?. Hopefully not. Then again, if you are fine and warm inside, it would not make a difference. Unless a dandy but horrible wolf came along. Then we would be  be warm but sad inside. Our only option would be to offer the sad and horrible wolf the opportunity to be warm and dandy.warm and fine. dandy and warm. fine but horrible. dandy but sad. sad and horrible.fine and warm, fine and dandy, fine and warm, fine and dandy");
        TotalLexBuilder b = new TotalLexBuilder(pos, neg);
        b.build(corpus);
    }

    public class Counter {
        public double count = 1.0;

        public void inc() {
            this.count += 1.0;
        }
    }
}

