/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.patterns;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openimaj.text.nlp.patterns.PatternProvider;

public class PunctuationPatternProvider
extends PatternProvider {
    String[] PunctCharsList = new String[]{"'", "\\|", "\\/", "\\-", "\u2026", "\u201c", "\u201d", "\"", ".", "?", "!", ",", ":", ";", "&", "*", "\u2018", "\u2019", "\u02bc", "\\<", "\\>", "\u00ab", "\u00bb", "{", "}", "\\(", "\\)", "\\[", "\\]", "\\\\", "\\|", "~", "="};
    private String charPuncs;

    public PunctuationPatternProvider() {
        String[] allpuncs = new String[this.PunctCharsList.length];
        this.charPuncs = "[";
        int i = 0;
        for (String punc : this.PunctCharsList) {
            allpuncs[i++] = String.format("[%s]+", punc);
            this.charPuncs = this.charPuncs + punc;
        }
        this.charPuncs = this.charPuncs + "]";
    }

    @Override
    public String patternString() {
        return this.charPuncs + "+";
    }

    public String charPattern() {
        return this.charPuncs;
    }

    public List<String> notMinus(String ... toIgnore) {
        ArrayList<String> allnotpuncs = new ArrayList<String>();
        List<String> ignoreArr = Arrays.asList(toIgnore);
        for (String punc : this.PunctCharsList) {
            if (ignoreArr.contains(punc)) continue;
            allnotpuncs.add(String.format("^%s", punc));
        }
        return allnotpuncs;
    }
}

