/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.text.nlp.namedentity;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class NGramGenerator<T> {
    private final Class<T> clazz;

    public NGramGenerator(Class<T> type) {
        this.clazz = type;
    }

    public <R extends T> List<T[]> getNGrams(List<R> tokens, int ... ngrams) {
        if (tokens == null) {
            return new ArrayList<T[]>();
        }
        ArrayList<T[]> result = new ArrayList<T[]>();
        for (int i = 0; i < tokens.size(); ++i) {
            for (int nsize : ngrams) {
                if (i + nsize > tokens.size()) continue;
                Object[] ngram = (Object[])Array.newInstance(this.clazz, nsize);
                for (int j = 0; j < nsize; ++j) {
                    ngram[j] = tokens.get(i + j);
                }
                result.add(ngram);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        StringNGramGenerator ngg = new StringNGramGenerator();
        List<T[]> ngrams = ngg.getNGrams(null, 3);
        for (Object[] objectArray : ngrams) {
            System.out.println(StringUtils.join((Object[])objectArray, (String)" "));
        }
    }

    public static class StringNGramGenerator
    extends NGramGenerator<String> {
        public StringNGramGenerator() {
            super(String.class);
        }
    }
}

