/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.feature;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import org.openimaj.feature.FeatureExtractor;
import org.openimaj.feature.SparseFloatFV;
import org.openimaj.util.array.SparseFloatArray;
import org.openimaj.util.array.SparseHashedFloatArray;

public class BagOfWordsFeatureExtractor
implements FeatureExtractor<SparseFloatFV, List<String>> {
    private List<String> dict;
    private TObjectIntHashMap<String> lookup;

    public BagOfWordsFeatureExtractor(List<String> dictionary) {
        this.dict = dictionary;
        this.lookup = new TObjectIntHashMap(10, 0.5f, -1);
        int index = 0;
        for (String string : dictionary) {
            this.lookup.put((Object)string, index++);
        }
    }

    public SparseFloatFV extractFeature(List<String> object) {
        SparseHashedFloatArray values = new SparseHashedFloatArray(this.dict.size());
        for (String string : object) {
            int index = this.asIndex(string);
            if (index < 0) continue;
            values.increment(index, 1.0f);
        }
        return new SparseFloatFV((SparseFloatArray)values);
    }

    private int asIndex(String string) {
        int found = this.lookup.get((Object)string);
        return found;
    }
}

