/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.series;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.openimaj.ml.timeseries.TimeSeries;
import org.openimaj.ml.timeseries.collection.TimeSeriesCollectionAssignable;
import org.openimaj.util.pair.IndependentPair;
import org.openimaj.util.reflection.ReflectionUtils;

public abstract class ConcreteTimeSeries<DATA, TS extends ConcreteTimeSeries<DATA, TS>>
extends TimeSeries<DATA[], DATA, TS>
implements TimeSeriesCollectionAssignable<DATA, TS> {
    private TreeMap<Long, DATA> timeSeries = new TreeMap();

    @Override
    public TS get(long time, int nbefore, int nafter) {
        if (nbefore < 0 || nafter < 0) {
            return (TS)((ConcreteTimeSeries)this.newInstance());
        }
        LinkedList dataList = new LinkedList();
        LinkedList<Long> timeList = new LinkedList<Long>();
        this.addBefore(timeList, dataList, time, nbefore);
        this.addCurrent(timeList, dataList, time);
        this.addAfter(timeList, dataList, time, nafter);
        return (TS)this.newInstance(timeList, (Collection)dataList);
    }

    private void set(Collection<Long> timeList, Collection<DATA> dataList) {
        this.timeSeries.clear();
        Iterator<DATA> dataIter = dataList.iterator();
        Iterator<Long> timeIter = timeList.iterator();
        while (dataIter.hasNext()) {
            this.timeSeries.put(timeIter.next(), dataIter.next());
        }
    }

    @Override
    public TS newInstance(Collection<Long> timeList, Collection<DATA> dataList) {
        ConcreteTimeSeries instance = (ConcreteTimeSeries)this.newInstance();
        Iterator<DATA> dataIter = dataList.iterator();
        Iterator<Long> timeIter = timeList.iterator();
        while (dataIter.hasNext()) {
            instance.timeSeries.put(timeIter.next(), dataIter.next());
        }
        return (TS)instance;
    }

    @Override
    public TS get(long time, int nbefore, int nafter, TS output) {
        if (nbefore < 0 || nafter < 0) {
            return (TS)((ConcreteTimeSeries)this.newInstance());
        }
        LinkedList dataList = new LinkedList();
        LinkedList<Long> timeList = new LinkedList<Long>();
        this.addBefore(timeList, dataList, time, nbefore);
        this.addCurrent(timeList, dataList, time);
        this.addAfter(timeList, dataList, time, nafter);
        super.set(timeList, dataList);
        return output;
    }

    @Override
    public TS get(long time, long threshbefore, long threshafter) {
        if (threshbefore < 0L || threshafter < 0L) {
            return (TS)((ConcreteTimeSeries)this.newInstance());
        }
        LinkedList dataList = new LinkedList();
        LinkedList<Long> timeList = new LinkedList<Long>();
        this.addBefore(timeList, dataList, time, threshbefore);
        this.addCurrent(timeList, dataList, time);
        this.addAfter(timeList, dataList, time, threshafter);
        return (TS)this.newInstance(timeList, (Collection)dataList);
    }

    @Override
    public TS get(long start, long end) {
        return (TS)this.get(start, 0L, end - start);
    }

    private void addAfter(LinkedList<Long> timeList, LinkedList<DATA> dataList, long time, long threshafter) {
        Map.Entry<Long, DATA> ceilEntry = null;
        long maxTime = time + threshafter;
        long currentTime = time + 1L;
        while ((ceilEntry = this.timeSeries.ceilingEntry(currentTime)) != null && (currentTime = ceilEntry.getKey().longValue()) <= maxTime) {
            dataList.addLast(ceilEntry.getValue());
            timeList.addLast(currentTime);
            ++currentTime;
        }
    }

    private void addCurrent(LinkedList<Long> timeList, LinkedList<DATA> dataList, long time) {
        DATA entry = this.timeSeries.get(time);
        if (entry != null) {
            dataList.addLast(entry);
            timeList.addLast(time);
        }
    }

    private void addBefore(LinkedList<Long> timeList, LinkedList<DATA> dataList, long time, long threshbefore) {
        Map.Entry<Long, DATA> floorEntry = null;
        long minTime = time - threshbefore;
        long currentTime = time;
        while ((floorEntry = this.timeSeries.lowerEntry(currentTime)) != null && (currentTime = floorEntry.getKey().longValue()) >= minTime) {
            dataList.addFirst(floorEntry.getValue());
            timeList.addFirst(currentTime);
        }
    }

    private void addAfter(LinkedList<Long> timeList, LinkedList<DATA> dataList, long time, int nafter) {
        Map.Entry<Long, DATA> ceilEntry = null;
        int seen = 0;
        long currentTime = time;
        while ((ceilEntry = this.timeSeries.higherEntry(currentTime)) != null) {
            currentTime = ceilEntry.getKey();
            if (seen >= nafter) break;
            dataList.addLast(ceilEntry.getValue());
            timeList.addLast(currentTime);
            ++seen;
        }
    }

    private void addBefore(LinkedList<Long> timeList, LinkedList<DATA> dataList, long time, int nbefore) {
        Map.Entry<Long, DATA> floorEntry = null;
        int seen = 0;
        long currentTime = time;
        while ((floorEntry = this.timeSeries.lowerEntry(currentTime)) != null) {
            currentTime = floorEntry.getKey();
            if (seen >= nbefore) break;
            dataList.addFirst(floorEntry.getValue());
            timeList.addFirst(currentTime);
            ++seen;
        }
    }

    public void add(long time, DATA value) {
        this.timeSeries.put(time, value);
    }

    @Override
    public void set(long[] time, DATA[] data) {
        for (int i = 0; i < time.length; ++i) {
            this.timeSeries.put(time[i], data[i]);
        }
    }

    @Override
    public long[] getTimes() {
        Set<Long> timeSet = this.timeSeries.keySet();
        long[] times = new long[timeSet.size()];
        int i = 0;
        for (long time : timeSet) {
            times[i++] = time;
        }
        return times;
    }

    @Override
    public DATA[] getData() {
        Collection<DATA> dataSet = this.timeSeries.values();
        DATA[] toret = dataSet.toArray(this.constructData(dataSet.size()));
        return toret;
    }

    private DATA[] constructData(int size) {
        Class a = (Class)ReflectionUtils.getTypeArguments(ConcreteTimeSeries.class, this.getClass()).get(0);
        return (Object[])Array.newInstance(a, size);
    }

    @Override
    public int size() {
        return this.timeSeries.size();
    }

    @Override
    public void internalAssign(TS assign) {
        this.set(((ConcreteTimeSeries)assign).getTimes(), ((ConcreteTimeSeries)assign).getData());
    }

    @Override
    public void internalAssign(long[] times, DATA[] data) {
        this.set(times, data);
    }

    @Override
    public void internalAssign(Collection<Long> times, Collection<DATA> data) {
        this.set(times, data);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        String lf = "+%s => %s\n";
        Iterator<Map.Entry<Long, DATA>> entryItr = this.timeSeries.entrySet().iterator();
        long last = 0L;
        for (int i = 0; i < this.size(); ++i) {
            Map.Entry<Long, DATA> entry = entryItr.next();
            long time = entry.getKey();
            DATA data = entry.getValue();
            Interval inter = new Interval(last, time);
            Period p = inter.toPeriod(PeriodType.yearDayTime());
            sb.append(String.format(lf, p, data));
            last = time;
        }
        return sb.toString();
    }

    @Override
    public Iterator<IndependentPair<Long, DATA>> iterator() {
        return new Iterator<IndependentPair<Long, DATA>>(){
            Iterator<Map.Entry<Long, DATA>> internal;
            {
                this.internal = ConcreteTimeSeries.this.timeSeries.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.internal.hasNext();
            }

            @Override
            public IndependentPair<Long, DATA> next() {
                Map.Entry next = this.internal.next();
                return IndependentPair.pair((Object)next.getKey(), next.getValue());
            }

            @Override
            public void remove() {
                this.internal.remove();
            }
        };
    }
}

