/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.timeseries.processor.interpolation;

import org.openimaj.ml.timeseries.processor.interpolation.TimeSeriesInterpolation;
import org.openimaj.ml.timeseries.processor.interpolation.util.TimeSpanUtils;
import org.openimaj.ml.timeseries.series.DoubleTimeSeries;

public class LinearInterpolationProcessor
extends TimeSeriesInterpolation {
    public LinearInterpolationProcessor(long[] times) {
        super(times);
    }

    public LinearInterpolationProcessor() {
    }

    public LinearInterpolationProcessor(long begin, int steps, long delta) {
        super(begin, steps, delta);
    }

    public LinearInterpolationProcessor(long begin, long end, int steps) {
        super(begin, end, steps);
    }

    public LinearInterpolationProcessor(long begin, long end, long delta) {
        super(begin, end, delta);
    }

    @Override
    public DoubleTimeSeries interpolate(DoubleTimeSeries timeSeries, long[] times) {
        if (times == null) {
            times = TimeSpanUtils.getTime(timeSeries.getTimes()[0], timeSeries.getTimes()[timeSeries.size() - 1], 1L);
        }
        double[] values = new double[times.length];
        DoubleTimeSeries dataholder = new DoubleTimeSeries(3);
        double[] holderdata = dataholder.getData();
        long[] holdertimes = dataholder.getTimes();
        int i = 0;
        for (long t : times) {
            timeSeries.get(t, 1, 1, dataholder);
            if (dataholder.size() == 3) {
                values[i++] = holderdata[1];
                continue;
            }
            if (dataholder.size() == 2) {
                if (holdertimes[0] == t) {
                    values[i++] = holderdata[0];
                    continue;
                }
                if (holdertimes[1] == t) {
                    values[i++] = holderdata[1];
                    continue;
                }
                double sum = holdertimes[1] - holdertimes[0];
                double weightLeft = sum - (double)(t - holdertimes[0]);
                double weightRight = sum - (double)(holdertimes[1] - t);
                values[i++] = (holderdata[0] * weightLeft + holderdata[1] * weightRight) / sum;
                continue;
            }
            values[i++] = holderdata[0];
        }
        return new DoubleTimeSeries(times, values);
    }
}

