/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.ml.annotation;

import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.ml.annotation.AbstractAnnotator;
import org.openimaj.ml.annotation.Annotated;
import org.openimaj.ml.annotation.AnnotatedObject;
import org.openimaj.ml.training.IncrementalTrainer;

public abstract class IncrementalAnnotator<OBJECT, ANNOTATION>
extends AbstractAnnotator<OBJECT, ANNOTATION>
implements IncrementalTrainer<Annotated<OBJECT, ANNOTATION>> {
    protected IncrementalAnnotator() {
    }

    @Override
    public void train(Iterable<? extends Annotated<OBJECT, ANNOTATION>> data) {
        for (Annotated<OBJECT, ANNOTATION> d : data) {
            this.train(d);
        }
    }

    public void trainMultiClass(GroupedDataset<ANNOTATION, ? extends ListDataset<OBJECT>, OBJECT> dataset) {
        for (Object grp : dataset.getGroups()) {
            for (Object inst : (ListDataset)dataset.getInstances(grp)) {
                this.train(new AnnotatedObject(inst, grp));
            }
        }
    }

    @Override
    public void train(GroupedDataset<ANNOTATION, ? extends ListDataset<OBJECT>, OBJECT> dataset) {
        for (AnnotatedObject<OBJECT, ANNOTATION> ao : AnnotatedObject.createList(dataset)) {
            this.train(ao);
        }
    }
}

