/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.threshold;

import org.openimaj.image.FImage;
import org.openimaj.image.processing.algorithm.FilterSupport;
import org.openimaj.image.processing.algorithm.MinMaxAnalyser;
import org.openimaj.image.processing.threshold.AbstractLocalThreshold;

public class AdaptiveLocalThresholdContrast
extends AbstractLocalThreshold {
    public AdaptiveLocalThresholdContrast(int size) {
        super(size);
    }

    public AdaptiveLocalThresholdContrast(int size_x, int size_y) {
        super(size_x, size_y);
    }

    public void processImage(FImage image) {
        MinMaxAnalyser minimax = new MinMaxAnalyser(FilterSupport.createBlockSupport(this.sizeX, this.sizeY));
        float[][] minpix = minimax.min.pixels;
        float[][] maxpix = minimax.max.pixels;
        float[][] ipix = image.pixels;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                ipix[y][x] = ipix[y][x] - minpix[y][x] > maxpix[y][x] - ipix[y][x] ? 1.0f : 0.0f;
            }
        }
    }
}

