/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.morphology;

import java.util.HashSet;
import java.util.Set;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.ConnectedComponent;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.morphology.StructuringElement;
import org.openimaj.image.processor.KernelProcessor;
import org.openimaj.image.processor.connectedcomponent.ConnectedComponentProcessor;
import org.openimaj.math.geometry.shape.Rectangle;

public class HitAndMiss
implements ConnectedComponentProcessor,
KernelProcessor<Float, FImage> {
    public static final HitAndMiss CONVEX_CORNERS = new HitAndMiss(new StructuringElement(new Pixel[]{new Pixel(0, -1), new Pixel(0, 0), new Pixel(1, 0)}, new Pixel[]{new Pixel(-1, 0), new Pixel(-1, 1), new Pixel(0, 1)}), new StructuringElement(new Pixel[]{new Pixel(0, -1), new Pixel(0, 0), new Pixel(-1, 0)}, new Pixel[]{new Pixel(1, 0), new Pixel(1, 1), new Pixel(0, 1)}), new StructuringElement(new Pixel[]{new Pixel(-1, 0), new Pixel(0, 0), new Pixel(0, 1)}, new Pixel[]{new Pixel(0, -1), new Pixel(1, -1), new Pixel(1, 0)}), new StructuringElement(new Pixel[]{new Pixel(0, 1), new Pixel(0, 0), new Pixel(1, 0)}, new Pixel[]{new Pixel(-1, -1), new Pixel(0, -1), new Pixel(-1, 0)}));
    protected Set<Pixel> outputPixels = new HashSet<Pixel>();
    protected StructuringElement[] elements;
    protected int cx;
    protected int cy;
    protected int sw = 0;
    protected int sh = 0;

    public HitAndMiss(StructuringElement ... ses) {
        this.elements = ses;
        for (StructuringElement se : ses) {
            int[] sz = se.size();
            if (this.sw < sz[0]) {
                this.sw = sz[0];
            }
            if (this.sh >= sz[1]) continue;
            this.sh = sz[1];
        }
        this.cx = this.sw / 2;
        this.cy = this.sw / 2;
    }

    public void process(ConnectedComponent cc) {
        this.outputPixels.clear();
        for (StructuringElement element : this.elements) {
            Set pixels = cc.getPixels();
            int[] se_size = element.size();
            Rectangle cc_bb = cc.calculateRegularBoundingBox();
            int j = (int)(cc_bb.y - (float)se_size[1]);
            while ((float)j <= cc_bb.y + (float)se_size[1] + cc_bb.height) {
                int i = (int)(cc_bb.x - (float)se_size[0]);
                while ((float)i <= cc_bb.x + (float)se_size[0] + cc_bb.width) {
                    Pixel p = new Pixel(i, j);
                    if (element.matches(p, pixels)) {
                        this.outputPixels.add(p);
                    }
                    ++i;
                }
                ++j;
            }
        }
    }

    public Set<Pixel> getPixels() {
        return this.outputPixels;
    }

    public int getKernelHeight() {
        return this.sh;
    }

    public int getKernelWidth() {
        return this.sw;
    }

    public Float processKernel(FImage patch) {
        for (StructuringElement element : this.elements) {
            int py;
            int px;
            int count = 0;
            for (Pixel p : element.positive) {
                px = this.cx - p.x;
                py = this.cy - p.y;
                if (px < 0 || py < 0 || px >= this.sw || py >= this.sh || patch.pixels[py][px] != 1.0f) continue;
                ++count;
            }
            for (Pixel p : element.negative) {
                px = this.cx - p.x;
                py = this.cy - p.y;
                if (px < 0 || py < 0 || px >= this.sw || py >= this.sh || patch.pixels[py][px] != 0.0f) continue;
                ++count;
            }
            if (count != element.positive.size() + element.negative.size()) continue;
            return Float.valueOf(1.0f);
        }
        return Float.valueOf(0.0f);
    }
}

