/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.edges;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.pixel.util.LineIterators;
import org.openimaj.image.processing.convolution.FSobel;
import org.openimaj.image.processing.edges.CannyEdgeDetector;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.math.geometry.line.Line2d;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.util.FloatArrayStatsUtils;

@Reference(type=ReferenceType.Inproceedings, author={"Epshtein, B.", "Ofek, E.", "Wexler, Y."}, title="Detecting text in natural scenes with stroke width transform", year="2010", booktitle="Computer Vision and Pattern Recognition (CVPR), 2010 IEEE Conference on", pages={"2963", "2970"}, customData={"keywords", "image processing;text analysis;image operator;image pixel;natural images;natural scenes;stroke width transform;text detection;Colored noise;Computer vision;Engines;Filter bank;Geometry;Image segmentation;Layout;Optical character recognition software;Pixel;Robustness", "doi", "10.1109/CVPR.2010.5540041", "ISSN", "1063-6919"})
public class StrokeWidthTransform
implements SinglebandImageProcessor<Float, FImage> {
    private static final int[][] edgeSearchRegion = new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}};
    private static final int[][] gradSearchRegion = new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {-1, -1}, {1, -1}, {-1, 1}, {1, 1}};
    private final CannyEdgeDetector canny;
    private boolean direction;
    private int maxStrokeWidth = 70;

    public StrokeWidthTransform(boolean direction, float sigma) {
        this.direction = direction;
        this.canny = new CannyEdgeDetector(sigma);
    }

    public StrokeWidthTransform(boolean direction, float lowThresh, float highThresh, float sigma) {
        this.direction = direction;
        this.canny = new CannyEdgeDetector(lowThresh, highThresh, sigma);
    }

    public void processImage(FImage image) {
        FSobel grads = new FSobel(this.canny.sigma);
        FImage edges = image.clone();
        this.canny.processImage(edges, grads);
        image.fill(Float.POSITIVE_INFINITY);
        List<List<Pixel>> rays = this.generateRays(edges, grads.dx, grads.dy, this.direction, image);
        this.medianFilter(image, rays);
    }

    private List<List<Pixel>> generateRays(FImage edges, FImage dx, FImage dy, boolean detectDark, FImage output) {
        ArrayList<List<Pixel>> rays = new ArrayList<List<Pixel>>();
        float gradDirection = detectDark ? -1.0f : 1.0f;
        for (int y = 0; y < output.height; ++y) {
            for (int x = 0; x < output.width; ++x) {
                if (!(edges.pixels[y][x] > 0.0f)) continue;
                this.traceRay(edges, dx, dy, detectDark, output, gradDirection, x, y, rays, 1, 0, 0, 1);
                this.traceRay(edges, dx, dy, detectDark, output, gradDirection, x, y, rays, 1, 1, -1, 1);
                this.traceRay(edges, dx, dy, detectDark, output, gradDirection, x, y, rays, 1, -1, 1, 1);
            }
        }
        return rays;
    }

    private void traceRay(FImage edges, FImage dx, FImage dy, boolean detectDark, FImage output, float gradDirection, int x, int y, List<List<Pixel>> rays, int xx, int xy, int yx, int yy) {
        float gradX = ((float)xx * dx.pixels[y][x] + (float)xy * dy.pixels[y][x]) * gradDirection;
        float gradY = ((float)yy * dy.pixels[y][x] + (float)yx * dx.pixels[y][x]) * gradDirection;
        Iterator iterator = LineIterators.bresenham((int)x, (int)y, (float)gradX, (float)gradY);
        Pixel start = ((Pixel)iterator.next()).clone();
        for (int j = 0; j < this.maxStrokeWidth; ++j) {
            Pixel current = (Pixel)iterator.next();
            if (current.x < 1 || current.x >= output.width - 1 || current.y < 1 || current.y >= output.height - 1) break;
            if (Math.abs(current.x - start.x) < 2 && Math.abs(current.y - start.y) < 2) continue;
            Pixel end = null;
            for (int i = 0; i < edgeSearchRegion.length; ++i) {
                int currentY = current.y + edgeSearchRegion[i][1];
                int currentX = current.x + edgeSearchRegion[i][0];
                if (!(edges.pixels[currentY][currentX] > 0.0f)) continue;
                end = new Pixel(currentX, currentY);
                break;
            }
            if (end == null) continue;
            boolean found = false;
            float startGradX = dx.pixels[start.y][start.x];
            float startGradY = dy.pixels[start.y][start.x];
            for (int i = 0; i < gradSearchRegion.length; ++i) {
                int currentY = end.y + gradSearchRegion[i][1];
                int currentX = end.x + gradSearchRegion[i][0];
                float currentGradX = dx.pixels[currentY][currentX];
                float currentGradY = dy.pixels[currentY][currentX];
                float tn = startGradY * currentGradX - startGradX * currentGradY;
                float td = startGradX * currentGradX + startGradY * currentGradY;
                if (!(tn * 7.0f < -td * 4.0f) || !(tn * 7.0f > td * 4.0f)) continue;
                found = true;
                break;
            }
            if (!found) break;
            float length = (float)Line2d.distance((Point2d)start, (Point2d)end);
            List ray = LineIterators.supercoverAsList((Pixel)start, (Pixel)end);
            for (Pixel p : ray) {
                output.pixels[p.y][p.x] = Math.min(length, output.pixels[p.y][p.x]);
            }
            rays.add(ray);
            break;
        }
    }

    private void medianFilter(FImage output, List<List<Pixel>> rays) {
        if (rays.size() == 0) {
            return;
        }
        Collections.sort(rays, new Comparator<List<Pixel>>(){

            @Override
            public int compare(List<Pixel> o1, List<Pixel> o2) {
                return o1.size() - o2.size();
            }
        });
        float[] working = new float[rays.get(rays.size() - 1).size()];
        for (List<Pixel> ray : rays) {
            int length = ray.size();
            for (int i = 0; i < length; ++i) {
                Pixel pixel = ray.get(i);
                working[i] = output.pixels[pixel.y][pixel.x];
            }
            float median = FloatArrayStatsUtils.median((float[])working, (int)0, (int)length);
            for (int i = 0; i < length; ++i) {
                Pixel pixel = ray.get(i);
                if (!(output.pixels[pixel.y][pixel.x] > median)) continue;
                output.pixels[pixel.y][pixel.x] = median;
            }
        }
    }

    public static FImage normaliseImage(FImage input) {
        FImage output = input.clone();
        float maxVal = 0.0f;
        float minVal = Float.MAX_VALUE;
        for (int row = 0; row < input.height; ++row) {
            for (int col = 0; col < input.width; ++col) {
                float val = input.pixels[row][col];
                if (val == Float.POSITIVE_INFINITY) continue;
                maxVal = Math.max(val, maxVal);
                minVal = Math.min(val, minVal);
            }
        }
        float difference = maxVal - minVal;
        for (int row = 0; row < input.height; ++row) {
            for (int col = 0; col < input.width; ++col) {
                float val = input.pixels[row][col];
                output.pixels[row][col] = val == Float.POSITIVE_INFINITY ? 1.0f : (val - minVal) / difference;
            }
        }
        return output;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setDirection(boolean direction) {
        this.direction = direction;
    }
}

