/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.convolution.SumBoxFilter;
import org.openimaj.image.processing.convolution.filterbank.LawsTextureBase;
import org.openimaj.image.processor.SinglebandImageProcessor;

@Reference(type=ReferenceType.Inproceedings, author={"Laws, K. I."}, title="{Rapid Texture Identification}", year="1980", booktitle="Proc. SPIE Conf. Image Processing for Missile Guidance", pages={"376", "", "380"}, customData={"citeulike-article-id", "2335645", "keywords", "bibtex-import", "posted-at", "2008-02-05 15:32:50", "priority", "2"})
public class LawsTexture
extends LawsTextureBase {
    private int macroWidth = 15;
    private int macroHeight = 15;

    public LawsTexture() {
    }

    public LawsTexture(int macro) {
        this.macroWidth = macro;
        this.macroHeight = macro;
    }

    public LawsTexture(int macroWidth, int macroHeight) {
        this.macroWidth = macroWidth;
        this.macroHeight = macroHeight;
    }

    @Override
    public void analyseImage(FImage in) {
        super.analyseImage(in);
        FImage[] tmpResp = this.responses;
        this.responses = new FImage[9];
        this.responses[0] = this.absAverage(tmpResp[0], tmpResp[1]);
        this.responses[1] = this.absAverage(tmpResp[2], tmpResp[3]);
        this.responses[2] = this.absAverage(tmpResp[4], tmpResp[5]);
        this.responses[3] = tmpResp[6].abs();
        this.responses[4] = tmpResp[7].abs();
        this.responses[5] = this.absAverage(tmpResp[8], tmpResp[9]);
        this.responses[6] = tmpResp[10].abs();
        this.responses[7] = this.absAverage(tmpResp[11], tmpResp[12]);
        this.responses[8] = this.absAverage(tmpResp[13], tmpResp[14]);
        for (int i = 0; i < 9; ++i) {
            this.responses[i] = (FImage)this.responses[i].processInplace((SinglebandImageProcessor)new SumBoxFilter(this.macroWidth, this.macroHeight));
        }
    }

    private FImage absAverage(FImage i1, FImage i2) {
        FImage img = new FImage(i1.width, i1.height);
        for (int y = 0; y < img.height; ++y) {
            for (int x = 0; x < img.width; ++x) {
                img.pixels[y][x] = Math.abs(i1.pixels[y][x] + i2.pixels[y][x]) / 2.0f;
            }
        }
        return img;
    }
}

