/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.convolution.filterbank;

import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import org.openimaj.feature.FloatFV;
import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.processing.algorithm.FourierTransform;
import org.openimaj.image.processing.convolution.FConvolution;

public abstract class FilterBank
implements ImageAnalyser<FImage> {
    private FConvolution[] filters;
    protected FImage[] responses;
    private FloatFFT_2D fft;
    private float[][][] preparedFilters;
    private float[][] tmpImage;
    private int paddingX;
    private int paddingY;

    protected FilterBank(FConvolution[] filters) {
        this.filters = filters;
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i = 0; i < filters.length; ++i) {
            maxWidth = Math.max(maxWidth, filters[i].kernel.width);
            maxHeight = Math.max(maxHeight, filters[i].kernel.height);
        }
        this.paddingX = (int)Math.ceil(maxWidth / 2);
        this.paddingY = (int)Math.ceil(maxHeight / 2);
    }

    public void analyseImage(FImage in) {
        this.responses = new FImage[this.filters.length];
        FImage image = (FImage)in.padding(this.paddingX, this.paddingY);
        int cols = image.getCols();
        int rows = image.getRows();
        if (this.fft == null || this.preparedFilters == null || this.preparedFilters[0].length != rows || this.preparedFilters[0][0].length != 2 * cols) {
            this.fft = new FloatFFT_2D(rows, cols);
            this.preparedFilters = new float[this.filters.length][][];
            this.tmpImage = new float[rows][cols * 2];
            for (int i = 0; i < this.preparedFilters.length; ++i) {
                float[][] preparedKernel = FourierTransform.prepareData(this.filters[i].kernel, rows, cols, false);
                this.fft.complexForward(preparedKernel);
                this.preparedFilters[i] = preparedKernel;
            }
        }
        float[][] preparedImage = FourierTransform.prepareData(image.pixels, rows, cols, false);
        this.fft.complexForward(preparedImage);
        for (int i = 0; i < this.preparedFilters.length; ++i) {
            this.responses[i] = this.convolve(cols, rows, preparedImage, this.preparedFilters[i]);
            this.responses[i] = this.responses[i].extractROI(2 * this.paddingX, 2 * this.paddingY, this.responses[i].width - 2 * this.paddingX, this.responses[i].height - 2 * this.paddingY);
        }
    }

    private FImage convolve(int cols, int rows, float[][] preparedImage, float[][] preparedFilter) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                float reImage = preparedImage[y][x * 2];
                float imImage = preparedImage[y][1 + x * 2];
                float reKernel = preparedFilter[y][x * 2];
                float imKernel = preparedFilter[y][1 + x * 2];
                float re = reImage * reKernel - imImage * imKernel;
                float im = reImage * imKernel + imImage * reKernel;
                this.tmpImage[y][x * 2] = re;
                this.tmpImage[y][1 + x * 2] = im;
            }
        }
        this.fft.complexInverse(this.tmpImage, true);
        FImage out = new FImage(cols, rows);
        FourierTransform.unprepareData(this.tmpImage, out, false);
        return out;
    }

    public FImage[] getResponseImages() {
        return this.responses;
    }

    public float[] getResponse(int x, int y) {
        float[] response = new float[this.responses.length];
        for (int i = 0; i < response.length; ++i) {
            response[i] = this.responses[i].getPixelNative(x, y);
        }
        return response;
    }

    public FloatFV getResponseFV(int x, int y) {
        return new FloatFV(this.getResponse(x, y));
    }

    public FImage renderFilters(int numFiltersX) {
        int border = 4;
        int numFiltersY = (int)Math.ceil((double)this.filters.length / (double)numFiltersX);
        int w = 4 + this.filters[0].kernel.width;
        int width = w * numFiltersX + 4;
        int h = 4 + this.filters[0].kernel.height;
        int height = h * numFiltersY + 4;
        FImage image = new FImage(width, height);
        image.fill(1.0f);
        int count = 0;
        for (int j = 0; j < numFiltersY; ++j) {
            for (int i = 0; i < numFiltersX && count < this.filters.length; ++i) {
                image.drawImage((Image)this.filters[count++].kernel.clone().normalise(), w * i + 4, h * j + 4);
            }
        }
        return image;
    }

    public float[][] getResponses() {
        int width = this.responses[0].width;
        int height = this.responses[0].height;
        float[][] resp = new float[width * height][this.responses.length];
        for (int i = 0; i < this.responses.length; ++i) {
            for (int y = 0; y < this.responses[0].height; ++y) {
                for (int x = 0; x < this.responses[0].width; ++x) {
                    resp[x + width * y][i] = this.responses[i].pixels[y][x];
                }
            }
        }
        return resp;
    }
}

