/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.pyramid.gaussian;

import org.openimaj.image.FImage;
import org.openimaj.image.Image;
import org.openimaj.image.analysis.pyramid.PyramidOptions;
import org.openimaj.image.analysis.pyramid.gaussian.GaussianOctave;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;

public class GaussianPyramidOptions<IMAGE extends Image<?, IMAGE>>
extends PyramidOptions<GaussianOctave<IMAGE>, IMAGE> {
    protected int borderPixels = 5;
    protected boolean doubleInitialImage = true;
    protected int extraScaleSteps = 2;
    protected float initialSigma = 1.6f;
    protected int scales = 3;

    public GaussianPyramidOptions() {
    }

    public GaussianPyramidOptions(GaussianPyramidOptions<?> options) {
        this.borderPixels = options.borderPixels;
        this.doubleInitialImage = options.doubleInitialImage;
        this.extraScaleSteps = options.extraScaleSteps;
        this.initialSigma = options.initialSigma;
        this.keepOctaves = options.keepOctaves;
        this.scales = options.scales;
    }

    public int getBorderPixels() {
        return this.borderPixels;
    }

    public int getExtraScaleSteps() {
        return this.extraScaleSteps;
    }

    public float getInitialSigma() {
        return this.initialSigma;
    }

    public int getScales() {
        return this.scales;
    }

    public boolean isDoubleInitialImage() {
        return this.doubleInitialImage;
    }

    public void setBorderPixels(int borderPixels) {
        if (borderPixels < 2) {
            throw new IllegalArgumentException("BorderDistance must be >= 2");
        }
        this.borderPixels = borderPixels;
    }

    public void setDoubleInitialImage(boolean doubleInitialImage) {
        this.doubleInitialImage = doubleInitialImage;
    }

    public void setExtraScaleSteps(int extraScaleSteps) {
        this.extraScaleSteps = extraScaleSteps;
    }

    public void setInitialSigma(float initialSigma) {
        this.initialSigma = initialSigma;
    }

    public void setScales(int scales) {
        this.scales = scales;
    }

    public SinglebandImageProcessor<Float, FImage> createGaussianBlur(float sigma) {
        return new FGaussianConvolve(sigma);
    }
}

