/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm.histogram;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.image.analysis.algorithm.histogram.SATWindowedExtractor;
import org.openimaj.image.processing.convolution.FImageGradients;

public class GradientOrientationHistogramExtractor
extends SATWindowedExtractor
implements ImageAnalyser<FImage> {
    private FImageGradients.Mode orientationMode;
    private boolean histogramInterpolation;

    public GradientOrientationHistogramExtractor(int nbins, boolean histogramInterpolation, FImageGradients.Mode orientationMode) {
        super(nbins);
        this.histogramInterpolation = histogramInterpolation;
        this.orientationMode = orientationMode;
    }

    public void analyseImage(FImage image) {
        FImage[] magnitudes = new FImage[this.nbins];
        for (int i = 0; i < this.nbins; ++i) {
            magnitudes[i] = new FImage(image.width, image.height);
        }
        FImageGradients.gradientMagnitudesAndQuantisedOrientations(image, magnitudes, this.histogramInterpolation, this.orientationMode);
        this.computeSATs(magnitudes);
    }

    public void analyseImage(FImage image, FImage edges) {
        int i;
        FImage[] magnitudes = new FImage[this.nbins];
        for (i = 0; i < this.nbins; ++i) {
            magnitudes[i] = new FImage(image.width, image.height);
        }
        FImageGradients.gradientMagnitudesAndQuantisedOrientations(image, magnitudes, this.histogramInterpolation, this.orientationMode);
        for (i = 0; i < this.nbins; ++i) {
            magnitudes[i].multiplyInplace(edges);
        }
        this.computeSATs(magnitudes);
    }
}

