/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.analysis.algorithm;

import org.openimaj.image.FImage;
import org.openimaj.image.analyser.ImageAnalyser;
import org.openimaj.math.geometry.shape.Rectangle;

public class SummedSqAreaTable
implements ImageAnalyser<FImage> {
    public FImage sum;
    public FImage sqSum;

    public SummedSqAreaTable() {
    }

    public SummedSqAreaTable(FImage image) {
        this.computeTable(image);
    }

    protected void computeTable(FImage image) {
        this.sum = new FImage(image.getWidth() + 1, image.getHeight() + 1);
        this.sqSum = new FImage(image.getWidth() + 1, image.getHeight() + 1);
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                float p = image.pixels[y][x];
                this.sum.pixels[y + 1][x + 1] = p + this.sum.pixels[y + 1][x] + this.sum.pixels[y][x + 1] - this.sum.pixels[y][x];
                this.sqSum.pixels[y + 1][x + 1] = p * p + this.sqSum.pixels[y + 1][x] + this.sqSum.pixels[y][x + 1] - this.sqSum.pixels[y][x];
            }
        }
    }

    public float calculateSumArea(int x1, int y1, int x2, int y2) {
        float A = this.sum.pixels[y1][x1];
        float B = this.sum.pixels[y1][x2];
        float C = this.sum.pixels[y2][x2];
        float D = this.sum.pixels[y2][x1];
        return A + C - B - D;
    }

    public float calculateSumArea(Rectangle r) {
        return this.calculateSumArea(Math.round(r.x), Math.round(r.y), Math.round(r.x + r.width), Math.round(r.y + r.height));
    }

    public float calculateSqSumArea(int x1, int y1, int x2, int y2) {
        float A = this.sqSum.pixels[y1][x1];
        float B = this.sqSum.pixels[y1][x2];
        float C = this.sqSum.pixels[y2][x2];
        float D = this.sqSum.pixels[y2][x1];
        return A + C - B - D;
    }

    public float calculateSqSumArea(Rectangle r) {
        return this.calculateSqSumArea(Math.round(r.x), Math.round(r.y), Math.round(r.x + r.width), Math.round(r.y + r.height));
    }

    public void analyseImage(FImage image) {
        this.computeTable(image);
    }
}

