/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.saliency;

import org.openimaj.citation.annotation.Reference;
import org.openimaj.citation.annotation.ReferenceType;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.colour.ColourSpace;
import org.openimaj.image.processing.convolution.FGaussianConvolve;
import org.openimaj.image.processor.SinglebandImageProcessor;
import org.openimaj.image.saliency.SaliencyMapGenerator;

@Reference(type=ReferenceType.Inproceedings, author={"Achanta, Radhakrishna", "Hemami, Sheila", "Estrada, Francisco", "S{\"u}sstrunk, Sabine"}, title="Frequency-tuned {S}alient {R}egion {D}etection", year="2009", booktitle="{IEEE} {I}nternational {C}onference on {C}omputer {V}ision and {P}attern {R}ecognition ({CVPR})", url="http://infoscience.epfl.ch/record/135217/files/1708.pdf", customData={"Affiliation", "EPFL", "Details", "http://infoscience.epfl.ch/record/135217", "Keywords", "IVRG; NCCR-MICS; NCCR-MICS/CL4; K-Space; PHAROS; Saliency; Segmentation; Frequency-domain analysis", "Location", "Miami Beach, Florida"})
public class AchantaSaliency
implements SaliencyMapGenerator<MBFImage> {
    protected float sigma;
    protected FImage map;

    public AchantaSaliency(float sigma) {
        this.sigma = sigma;
    }

    public AchantaSaliency() {
        this.sigma = 1.0f;
    }

    public void analyseImage(MBFImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        MBFImage lab = ColourSpace.convert((MBFImage)image, (ColourSpace)ColourSpace.CIE_Lab);
        float[][] Lb = ((FImage)lab.getBand((int)0)).pixels;
        float[][] ab = ((FImage)lab.getBand((int)1)).pixels;
        float[][] bb = ((FImage)lab.getBand((int)2)).pixels;
        float mL = 0.0f;
        float ma = 0.0f;
        float mb = 0.0f;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                mL += Lb[y][x];
                ma += ab[y][x];
                mb += bb[y][x];
            }
        }
        mL /= (float)(height * width);
        ma /= (float)(height * width);
        mb /= (float)(height * width);
        MBFImage blur = (MBFImage)lab.process((SinglebandImageProcessor)new FGaussianConvolve(this.sigma));
        Lb = ((FImage)blur.getBand((int)0)).pixels;
        ab = ((FImage)blur.getBand((int)1)).pixels;
        bb = ((FImage)blur.getBand((int)2)).pixels;
        this.map = new FImage(width, height);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                float dL = Lb[y][x] - mL;
                float da = ab[y][x] - ma;
                float db = bb[y][x] - mb;
                this.map.pixels[y][x] = dL * dL + da * da + db * db;
            }
        }
        this.map.normalise();
    }

    @Override
    public FImage getSaliencyMap() {
        return this.map;
    }
}

