/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.pixel.statistics;

import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.image.FImage;
import org.openimaj.image.MBFImage;
import org.openimaj.image.pixel.statistics.AbstractPixelStatisticsModel;
import org.openimaj.math.statistics.distribution.MultidimensionalHistogram;

public class BlockHistogramModel
extends AbstractPixelStatisticsModel
implements FeatureVectorProvider<MultidimensionalHistogram> {
    private static final long serialVersionUID = 1L;
    public MultidimensionalHistogram[][] histograms;
    int blocks_x;
    int blocks_y;
    int[] dims;

    public BlockHistogramModel(int blocks_x, int blocks_y, int ... nbins) {
        super(nbins.length);
        this.dims = nbins;
        this.blocks_x = blocks_x;
        this.blocks_y = blocks_y;
        this.histograms = new MultidimensionalHistogram[blocks_y][blocks_x];
        for (int y = 0; y < blocks_y; ++y) {
            for (int x = 0; x < blocks_x; ++x) {
                this.histograms[y][x] = new MultidimensionalHistogram(this.dims);
            }
        }
    }

    public MultidimensionalHistogram toSingleHistogram() {
        int[] newdims = new int[this.dims.length + 2];
        for (int i = 0; i < this.dims.length; ++i) {
            newdims[i] = this.dims[i];
        }
        newdims[this.dims.length] = this.blocks_x;
        newdims[this.dims.length + 1] = this.blocks_y;
        MultidimensionalHistogram h = new MultidimensionalHistogram(newdims);
        for (int y = 0; y < this.blocks_y; ++y) {
            for (int x = 0; x < this.blocks_x; ++x) {
                int blkid = x + y * this.blocks_x;
                for (int i = 0; i < ((double[])this.histograms[y][x].values).length; ++i) {
                    ((double[])h.values)[i + blkid * ((double[])this.histograms[y][x].values).length] = ((double[])this.histograms[y][x].values)[i];
                }
            }
        }
        return h;
    }

    protected void reset(MultidimensionalHistogram histogram) {
        for (int i = 0; i < ((double[])histogram.values).length; ++i) {
            ((double[])histogram.values)[i] = 0.0;
        }
    }

    @Override
    public void estimateModel(MBFImage ... images) {
        int x;
        for (int y = 0; y < this.blocks_y; ++y) {
            for (x = 0; x < this.blocks_x; ++x) {
                this.reset(this.histograms[y][x]);
            }
        }
        for (MBFImage img : images) {
            for (int y = 0; y < this.blocks_y; ++y) {
                for (int x2 = 0; x2 < this.blocks_x; ++x2) {
                    this.accum(img, x2, y);
                }
            }
        }
        for (int y = 0; y < this.blocks_y; ++y) {
            for (x = 0; x < this.blocks_x; ++x) {
                this.histograms[y][x].normalise();
            }
        }
    }

    protected void accum(MBFImage im, int bx, int by) {
        assert (im.numBands() == this.ndims);
        MultidimensionalHistogram histogram = this.histograms[by][bx];
        int height = im.getHeight();
        int width = im.getWidth();
        int cols_per_block = width / this.blocks_x;
        int startx = bx * cols_per_block;
        int stopx = (1 + bx) * cols_per_block;
        int rows_per_block = height / this.blocks_y;
        int starty = by * rows_per_block;
        int stopy = (1 + by) * rows_per_block;
        if (stopx >= width) {
            stopx = width;
        }
        if (stopy >= height) {
            stopy = height;
        }
        for (int y = starty; y < stopy; ++y) {
            for (int x = startx; x < stopx; ++x) {
                int[] bins = new int[this.ndims];
                for (int i = 0; i < this.ndims; ++i) {
                    bins[i] = (int)(((FImage)im.getBand((int)i)).pixels[y][x] * (float)histogram.nbins[i]);
                    if (bins[i] < histogram.nbins[i]) continue;
                    bins[i] = histogram.nbins[i] - 1;
                }
                int bin = 0;
                for (int i = 0; i < this.ndims; ++i) {
                    int f = 1;
                    for (int j = 0; j < i; ++j) {
                        f *= histogram.nbins[j];
                    }
                    bin += f * bins[i];
                }
                double[] dArray = (double[])histogram.values;
                int n = bin;
                dArray[n] = dArray[n] + 1.0;
            }
        }
    }

    public String toString() {
        String s = "LocalHistogram[\n";
        for (int y = 0; y < this.blocks_y; ++y) {
            for (int x = 0; x < this.blocks_x; ++x) {
                s = s + "\t(" + x + ", " + y + ") = " + this.histograms[y][x].toString() + "\n";
            }
        }
        s = s + "]\n";
        return s;
    }

    public BlockHistogramModel clone() {
        BlockHistogramModel model = new BlockHistogramModel(this.blocks_x, this.blocks_x, this.dims);
        model.histograms = new MultidimensionalHistogram[this.blocks_y][this.blocks_x];
        for (int y = 0; y < this.blocks_y; ++y) {
            for (int x = 0; x < this.blocks_x; ++x) {
                model.histograms[y][x] = this.histograms[y][x].clone();
            }
        }
        return model;
    }

    public MultidimensionalHistogram getFeatureVector() {
        return this.toSingleHistogram();
    }
}

