/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.model.asm.datasets;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.openimaj.data.DataUtils;
import org.openimaj.experiment.annotations.DatasetDescription;
import org.openimaj.image.Image;
import org.openimaj.image.model.asm.datasets.ShapeModelDataset;
import org.openimaj.image.model.asm.datasets.ShapeModelDatasets;
import org.openimaj.io.InputStreamObjectReader;

@DatasetDescription(name="Tim Cootes's sample appearance modelling data", description="The sample data (images, points and connections) that come with Tim Cootes's am_tools software.", creator="Tim Cootes", url="http://www.isbe.man.ac.uk/~bim/software/am_tools_doc/", downloadUrls={"http://datasets.openimaj.org/am_tools_data.zip"})
public class AMToolsSampleDataset {
    private static final String DATA_ZIP = "am_tools_data.zip";
    private static final String DATA_DOWNLOAD_URL = "http://datasets.openimaj.org/am_tools_data.zip";

    public static <IMAGE extends Image<?, IMAGE>> ShapeModelDataset<IMAGE> load(InputStreamObjectReader<IMAGE> reader) throws IOException {
        String basePath = AMToolsSampleDataset.downloadAndGetPath();
        return ShapeModelDatasets.loadPTSDataset(basePath + "points/", basePath + "images/", basePath + "models/face.parts", reader);
    }

    private static String downloadAndGetPath() throws IOException {
        File dataset = DataUtils.getDataLocation((String)DATA_ZIP);
        if (!dataset.exists()) {
            dataset.getParentFile().mkdirs();
            FileUtils.copyURLToFile((URL)new URL(DATA_DOWNLOAD_URL), (File)dataset);
        }
        return "zip:file:" + dataset.toString() + "!am_tools_data/";
    }
}

