/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.feature;

import Jama.Matrix;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openimaj.feature.FeatureVectorProvider;
import org.openimaj.feature.FloatFV;
import org.openimaj.image.FImage;
import org.openimaj.image.pixel.Pixel;
import org.openimaj.image.processing.face.alignment.AffineAligner;
import org.openimaj.image.processing.face.detection.keypoints.FKEFaceDetector;
import org.openimaj.image.processing.face.detection.keypoints.FacialKeypoint;
import org.openimaj.image.processing.face.detection.keypoints.KEDetectedFace;
import org.openimaj.image.processing.face.feature.FacialFeature;
import org.openimaj.image.processing.face.feature.FacialFeatureExtractor;
import org.openimaj.io.ReadWriteableBinary;
import org.openimaj.io.wrappers.ReadableListBinary;
import org.openimaj.io.wrappers.WriteableListBinary;
import org.openimaj.math.geometry.point.Point2d;
import org.openimaj.math.geometry.point.Point2dImpl;

public class FacePatchFeature
implements FacialFeature,
FeatureVectorProvider<FloatFV> {
    static final int[][] VP = new int[][]{{0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {0, 1}, {2, 3}, {1, 2}, {7, 8}};
    protected FloatFV featureVector;
    protected int radius = 7;
    protected float scl = 1.0f;
    protected List<DetectedFacePart> faceParts = new ArrayList<DetectedFacePart>();

    protected void initialise(KEDetectedFace face) {
        this.extractFeatures(face);
        this.featureVector = this.createFeatureVector();
    }

    protected FloatFV createFeatureVector() {
        int length = this.faceParts.get((int)0).featureVector.length;
        FloatFV fv = new FloatFV(this.faceParts.size() * length);
        for (int i = 0; i < this.faceParts.size(); ++i) {
            System.arraycopy(this.faceParts.get((int)i).featureVector, 0, fv.values, i * length, length);
        }
        return fv;
    }

    protected void extractFeatures(KEDetectedFace face) {
        Matrix T0 = AffineAligner.estimateAffineTransform(face);
        Matrix T = T0.copy();
        FImage J = FKEFaceDetector.pyramidResize(face.getFacePatch(), T);
        FacialKeypoint[] pts = face.getKeypoints();
        this.faceParts.clear();
        float pyrScale = (float)(T0.get(0, 2) / T.get(0, 2));
        Point2dImpl[] P0 = new Point2dImpl[VP.length];
        for (int j = 0; j < P0.length; ++j) {
            int[] vp = VP[j];
            int vp0 = vp[0];
            P0[j] = new Point2dImpl(0.0f, 0.0f);
            if (vp.length == 1) {
                P0[j].x = pts[vp0].position.x / pyrScale;
                P0[j].y = pts[vp0].position.y / pyrScale;
                continue;
            }
            int vp1 = vp[1];
            P0[j].x = (pts[vp0].position.x + pts[vp1].position.x) / 2.0f / pyrScale;
            P0[j].y = (pts[vp0].position.y + pts[vp1].position.y) / 2.0f / pyrScale;
        }
        ArrayList<Point2dImpl> transformed = new ArrayList<Point2dImpl>();
        ArrayList<Pixel> nontransformed = new ArrayList<Pixel>();
        for (int rr = -this.radius; rr <= this.radius; ++rr) {
            for (int cc = -this.radius; cc <= this.radius; ++cc) {
                float r2 = rr * rr + cc * cc;
                if (!(r2 <= (float)(this.radius * this.radius))) continue;
                float px = (float)((double)((float)cc * this.scl) * T.get(0, 0) + (double)((float)rr * this.scl) * T.get(0, 1));
                float py = (float)((double)((float)cc * this.scl) * T.get(1, 0) + (double)((float)rr * this.scl) * T.get(1, 1));
                transformed.add(new Point2dImpl(px, py));
                nontransformed.add(new Pixel(cc, rr));
            }
        }
        for (int j = 0; j < VP.length; ++j) {
            DetectedFacePart pd = new DetectedFacePart(FacialKeypoint.FacialKeypointType.valueOf(j), (Point2d)new Point2dImpl(P0[j].x * pyrScale, P0[j].y * pyrScale));
            this.faceParts.add(pd);
            pd.featureVector = new float[transformed.size()];
            int n = 0;
            float mean = 0.0f;
            float m2 = 0.0f;
            for (int i = 0; i < transformed.size(); ++i) {
                float val;
                Point2dImpl XYt = (Point2dImpl)transformed.get(i);
                double xt = XYt.x + P0[j].x;
                double yt = XYt.y + P0[j].y;
                pd.featureVector[i] = val = J.getPixelInterp(xt, yt).floatValue();
                float delta = val - mean;
                m2 += delta * (val - (mean += delta / (float)(++n)));
            }
            float std = (float)Math.sqrt(m2 / (float)(n - 1));
            if (std <= 0.0f) {
                std = 1.0f;
            }
            for (int i = 0; i < transformed.size(); ++i) {
                pd.featureVector[i] = (pd.featureVector[i] - mean) / std;
            }
        }
    }

    public FloatFV getFeatureVector() {
        return this.featureVector;
    }

    public void readBinary(DataInput in) throws IOException {
        this.featureVector = new FloatFV();
        this.featureVector.readBinary(in);
        this.radius = in.readInt();
        this.scl = in.readFloat();
        new ReadableListBinary<DetectedFacePart>(this.faceParts){

            protected DetectedFacePart readValue(DataInput in) throws IOException {
                DetectedFacePart v = new DetectedFacePart();
                v.readBinary(in);
                return v;
            }
        }.readBinary(in);
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        this.featureVector.writeBinary(out);
        out.writeInt(this.radius);
        out.writeFloat(this.scl);
        new WriteableListBinary<DetectedFacePart>(this.faceParts){

            protected void writeValue(DetectedFacePart v, DataOutput out) throws IOException {
                v.writeBinary(out);
            }
        }.writeBinary(out);
    }

    public static class DetectedFacePart
    extends FacialKeypoint
    implements ReadWriteableBinary {
        float[] featureVector;
        int featureRadius;

        public DetectedFacePart() {
        }

        public DetectedFacePart(FacialKeypoint.FacialKeypointType type, Point2d position) {
            super(type, position);
        }

        public FImage getImage() {
            FImage image = new FImage(2 * this.featureRadius + 1, 2 * this.featureRadius + 1);
            int i = 0;
            for (int rr = -this.featureRadius; rr <= this.featureRadius; ++rr) {
                for (int cc = -this.featureRadius; cc <= this.featureRadius; ++cc) {
                    float r2 = rr * rr + cc * cc;
                    if (!(r2 <= (float)(this.featureRadius * this.featureRadius))) continue;
                    float value = this.featureVector[i++];
                    image.pixels[rr + this.featureRadius][cc + this.featureRadius] = value < -3.0f ? 0.0f : (value >= 3.0f ? 1.0f : (3.0f + value) / 6.0f);
                }
            }
            return image;
        }

        @Override
        public void readBinary(DataInput in) throws IOException {
            super.readBinary(in);
            int sz = in.readInt();
            if (sz < 0) {
                this.featureVector = null;
            } else {
                this.featureVector = new float[sz];
                for (int i = 0; i < sz; ++i) {
                    this.featureVector[i] = in.readFloat();
                }
            }
            this.featureRadius = in.readInt();
        }

        @Override
        public byte[] binaryHeader() {
            return this.getClass().getName().getBytes();
        }

        @Override
        public void writeBinary(DataOutput out) throws IOException {
            super.writeBinary(out);
            if (this.featureVector == null) {
                out.writeInt(-1);
            } else {
                out.writeInt(this.featureVector.length);
                for (float f : this.featureVector) {
                    out.writeFloat(f);
                }
            }
            out.writeInt(this.featureRadius);
        }
    }

    public static class Extractor
    implements FacialFeatureExtractor<FacePatchFeature, KEDetectedFace> {
        public FacePatchFeature extractFeature(KEDetectedFace face) {
            FacePatchFeature f = new FacePatchFeature();
            f.initialise(face);
            return f;
        }

        public void readBinary(DataInput in) throws IOException {
        }

        public byte[] binaryHeader() {
            return null;
        }

        public void writeBinary(DataOutput out) throws IOException {
        }
    }
}

