/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.detection;

import java.util.List;
import org.openimaj.data.dataset.GroupedDataset;
import org.openimaj.data.dataset.ListBackedDataset;
import org.openimaj.data.dataset.ListDataset;
import org.openimaj.data.dataset.MapBackedDataset;
import org.openimaj.image.Image;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.face.detection.FaceDetector;

public class DatasetFaceDetector {
    private DatasetFaceDetector() {
    }

    public static <PERSON, IMAGE extends Image<?, IMAGE>, FACE extends DetectedFace> GroupedDataset<PERSON, ListDataset<FACE>, FACE> process(GroupedDataset<PERSON, ? extends ListDataset<IMAGE>, IMAGE> input, FaceDetector<FACE, IMAGE> detector) {
        MapBackedDataset output = new MapBackedDataset();
        for (Object group : input.getGroups()) {
            ListBackedDataset detected = new ListBackedDataset();
            ListDataset instances = (ListDataset)input.getInstances(group);
            for (int i = 0; i < instances.size(); ++i) {
                Image img = (Image)instances.getInstance(i);
                List<FACE> faces = detector.detectFaces(img);
                if (faces == null || faces.size() == 0) {
                    System.err.println("There was no face detected in " + group + " instance " + i);
                    continue;
                }
                if (faces.size() == 1) {
                    detected.add(faces.get(0));
                    continue;
                }
                detected.add(DatasetFaceDetector.getBiggest(faces));
            }
            output.getMap().put(group, detected);
        }
        return output;
    }

    public static <IMAGE extends Image<?, IMAGE>, FACE extends DetectedFace> ListDataset<FACE> process(List<IMAGE> instances, FaceDetector<FACE, IMAGE> detector) {
        ListBackedDataset detected = new ListBackedDataset();
        for (int i = 0; i < instances.size(); ++i) {
            Image img = (Image)instances.get(i);
            List<FACE> faces = detector.detectFaces(img);
            if (faces == null || faces.size() == 0) {
                System.err.println("There was no face detected in instance " + i);
                continue;
            }
            if (faces.size() == 1) {
                detected.add(faces.get(0));
                continue;
            }
            detected.add(DatasetFaceDetector.getBiggest(faces));
        }
        return detected;
    }

    public static <FACE extends DetectedFace> FACE getBiggest(List<FACE> faces) {
        if (faces == null || faces.size() == 0) {
            return null;
        }
        int biggestIndex = 0;
        double biggestSize = ((DetectedFace)faces.get((int)0)).bounds.calculateArea();
        for (int i = 1; i < faces.size(); ++i) {
            double sz = ((DetectedFace)faces.get((int)i)).bounds.calculateArea();
            if (!(sz > biggestSize)) continue;
            biggestSize = sz;
            biggestIndex = i;
        }
        return (FACE)((DetectedFace)faces.get(biggestIndex));
    }
}

