/*
 * Decompiled with CFR 0.152.
 */
package org.openimaj.image.processing.face.alignment;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.openimaj.image.FImage;
import org.openimaj.image.processing.face.alignment.FaceAligner;
import org.openimaj.image.processing.face.detection.DetectedFace;
import org.openimaj.image.processing.resize.ResizeProcessor;

public class ScalingAligner<T extends DetectedFace>
implements FaceAligner<T> {
    private int width;
    private int height;

    public ScalingAligner() {
        this(100, 100);
    }

    public ScalingAligner(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public FImage align(DetectedFace face) {
        return ResizeProcessor.resample((FImage)face.getFacePatch(), (int)this.width, (int)this.height);
    }

    @Override
    public FImage getMask() {
        return null;
    }

    public void readBinary(DataInput in) throws IOException {
        this.width = in.readInt();
        this.height = in.readInt();
    }

    public byte[] binaryHeader() {
        return this.getClass().getName().getBytes();
    }

    public void writeBinary(DataOutput out) throws IOException {
        out.writeInt(this.width);
        out.writeInt(this.height);
    }
}

