/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.validation;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Severity;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.validation.ValidationExceptionHandler;
import ca.uhn.hl7v2.validation.impl.SimpleValidationExceptionHandler;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;

public class Validator {
    public static void validate(Message msg, HapiContext context) {
        HapiContext ctx = context == null ? msg.getParser().getHapiContext() : context;
        SimpleValidationExceptionHandler handler = new SimpleValidationExceptionHandler(ctx);
        handler.setMinimumSeverityToCollect(Severity.ERROR);
        try {
            if (((Boolean)ctx.getMessageValidator().validate(msg, (ValidationExceptionHandler)handler)).booleanValue()) {
                throw new ValidationException("Message validation failed", handler.getExceptions());
            }
        }
        catch (HL7Exception hl7Exception) {
            throw new ValidationException("Message validation failed", (Throwable)hl7Exception);
        }
    }
}

