/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class NormalizedNodeStreamWriterStack
implements LeafrefResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizedNodeStreamWriterStack.class);
    private final Deque<DocumentedNode.WithStatus> schemaStack = new ArrayDeque<DocumentedNode.WithStatus>();
    private final SchemaInferenceStack dataTree;
    private final DataNodeContainer root;

    private NormalizedNodeStreamWriterStack(EffectiveModelContext context) {
        this.dataTree = SchemaInferenceStack.of((EffectiveModelContext)context);
        this.root = (DataNodeContainer)Objects.requireNonNull(context);
    }

    private NormalizedNodeStreamWriterStack(SchemaInferenceStack dataTree) {
        this.dataTree = Objects.requireNonNull(dataTree);
        if (!dataTree.isEmpty()) {
            EffectiveStatement current = dataTree.currentStatement();
            Preconditions.checkArgument((boolean)(current instanceof DataNodeContainer), (String)"Cannot instantiate on %s", (Object)current);
            this.root = (DataNodeContainer)current;
        } else {
            this.root = dataTree.getEffectiveModelContext();
        }
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveStatementInference root) {
        return new NormalizedNodeStreamWriterStack(SchemaInferenceStack.ofInference((EffectiveStatementInference)root));
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(SchemaInferenceStack.Inference root) {
        return new NormalizedNodeStreamWriterStack(root.toSchemaInferenceStack());
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context) {
        return new NormalizedNodeStreamWriterStack(context);
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context, SchemaNodeIdentifier.Absolute path) {
        return new NormalizedNodeStreamWriterStack(SchemaInferenceStack.of((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)path));
    }

    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context, YangInstanceIdentifier path) {
        return new NormalizedNodeStreamWriterStack(((DataSchemaContextTree.NodeAndStack)DataSchemaContextTree.from(context).enterPath(path).orElseThrow()).stack());
    }

    @Deprecated
    public static @NonNull NormalizedNodeStreamWriterStack of(EffectiveModelContext context, SchemaPath path) {
        return new NormalizedNodeStreamWriterStack(SchemaInferenceStack.ofSchemaPath((EffectiveModelContext)context, (SchemaPath)path));
    }

    public static @NonNull NormalizedNodeStreamWriterStack ofOperation(EffectiveModelContext context, SchemaNodeIdentifier.Absolute operation, QName qname) {
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)context, (SchemaNodeIdentifier.Absolute)operation);
        EffectiveStatement current = stack.currentStatement();
        Preconditions.checkArgument((current instanceof RpcEffectiveStatement || current instanceof ActionEffectiveStatement ? 1 : 0) != 0, (String)"Path %s resolved into non-operation %s", (Object)operation, (Object)current);
        stack.enterSchemaTree(qname);
        return new NormalizedNodeStreamWriterStack(stack);
    }

    public TypeDefinition<?> resolveLeafref(LeafrefTypeDefinition type) {
        return this.dataTree.resolveLeafref(type);
    }

    public Object getParent() {
        DocumentedNode.WithStatus schema = this.schemaStack.peek();
        return schema == null ? this.root : schema;
    }

    private SchemaNode enterDataTree(YangInstanceIdentifier.PathArgument name) {
        QName qname = name.getNodeType();
        DataTreeEffectiveStatement stmt = this.dataTree.enterDataTree(qname);
        Verify.verify((boolean)(stmt instanceof SchemaNode), (String)"Unexpected result %s", (Object)stmt);
        SchemaNode ret = (SchemaNode)stmt;
        Object parent = this.getParent();
        if (parent instanceof ChoiceSchemaNode) {
            DataSchemaNode check = ((ChoiceSchemaNode)parent).findDataSchemaChild(qname).orElse(null);
            Verify.verify((check == ret ? 1 : 0) != 0, (String)"Data tree result %s does not match choice result %s", (Object)ret, (Object)check);
        }
        return ret;
    }

    public void startList(YangInstanceIdentifier.PathArgument name) {
        SchemaNode schema = this.enterDataTree(name);
        Preconditions.checkArgument((boolean)(schema instanceof ListSchemaNode), (String)"Node %s is not a list", (Object)schema);
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
    }

    public void startListItem(YangInstanceIdentifier.PathArgument name) throws IOException {
        Object schema = this.getParent();
        Preconditions.checkArgument((boolean)(schema instanceof ListSchemaNode), (Object)"List item is not appropriate");
        this.schemaStack.push((DocumentedNode.WithStatus)((ListSchemaNode)schema));
    }

    public void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        SchemaNode schema = this.enterDataTree((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof LeafSchemaNode), (String)"Node %s is not a leaf", (Object)schema);
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
    }

    public LeafListSchemaNode startLeafSet(YangInstanceIdentifier.NodeIdentifier name) {
        SchemaNode schema = this.enterDataTree((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof LeafListSchemaNode), (String)"Node %s is not a leaf-list", (Object)schema);
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
        return (LeafListSchemaNode)schema;
    }

    public LeafListSchemaNode leafSetEntryNode(QName qname) {
        Object parent = this.getParent();
        if (parent instanceof LeafListSchemaNode) {
            return (LeafListSchemaNode)parent;
        }
        Preconditions.checkArgument((boolean)(parent instanceof DataNodeContainer), (String)"Cannot lookup %s in parent %s", (Object)qname, (Object)parent);
        DataSchemaNode child = ((DataNodeContainer)parent).dataChildByName(qname);
        Preconditions.checkArgument((boolean)(child instanceof LeafListSchemaNode), (String)"Node %s is neither a leaf-list nor currently in a leaf-list", (Object)child);
        return (LeafListSchemaNode)child;
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) {
        this.schemaStack.push((DocumentedNode.WithStatus)this.leafSetEntryNode(name.getNodeType()));
    }

    public ChoiceSchemaNode startChoiceNode(YangInstanceIdentifier.NodeIdentifier name) {
        LOG.debug("Enter choice {}", (Object)name);
        ChoiceEffectiveStatement stmt = this.dataTree.enterChoice(name.getNodeType());
        Verify.verify((boolean)(stmt instanceof ChoiceSchemaNode), (String)"Node %s is not a choice", (Object)stmt);
        ChoiceSchemaNode ret = (ChoiceSchemaNode)stmt;
        this.schemaStack.push((DocumentedNode.WithStatus)ret);
        return ret;
    }

    public SchemaNode startContainerNode(YangInstanceIdentifier.NodeIdentifier name) {
        SchemaNode schema;
        LOG.debug("Enter container {}", (Object)name);
        if (this.schemaStack.isEmpty() && this.root instanceof NotificationDefinition) {
            schema = (NotificationDefinition)this.root;
        } else {
            schema = this.enterDataTree((YangInstanceIdentifier.PathArgument)name);
            Preconditions.checkArgument((boolean)(schema instanceof ContainerLike), (String)"Node %s is not a container", (Object)schema);
        }
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
        return schema;
    }

    public void startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name) {
        SchemaNode schema = this.enterDataTree((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof AnyxmlSchemaNode), (String)"Node %s is not anyxml", (Object)schema);
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
    }

    public void startAnydataNode(YangInstanceIdentifier.NodeIdentifier name) {
        SchemaNode schema = this.enterDataTree((YangInstanceIdentifier.PathArgument)name);
        Preconditions.checkArgument((boolean)(schema instanceof AnydataSchemaNode), (String)"Node %s is not anydata", (Object)schema);
        this.schemaStack.push((DocumentedNode.WithStatus)schema);
    }

    public Object endNode() {
        DocumentedNode.WithStatus ret = this.schemaStack.pop();
        if (!(ret instanceof AugmentationSchemaNode) && this.getParent() != ret) {
            this.dataTree.exit();
        }
        return ret;
    }

    public AugmentationSchemaNode startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) {
        LOG.debug("Enter augmentation {}", (Object)identifier);
        Object parent = this.getParent();
        Preconditions.checkArgument((boolean)(parent instanceof AugmentationTarget), (String)"Augmentation not allowed under %s", (Object)parent);
        if (parent instanceof ChoiceSchemaNode) {
            QName name = (QName)Iterables.get((Iterable)identifier.getPossibleChildNames(), (int)0);
            parent = NormalizedNodeStreamWriterStack.findCaseByChild((ChoiceSchemaNode)parent, name);
        }
        Preconditions.checkArgument((boolean)(parent instanceof DataNodeContainer), (String)"Augmentation allowed only in DataNodeContainer", (Object)parent);
        AugmentationSchemaNode schema = NormalizedNodeStreamWriterStack.findSchemaForAugment((AugmentationTarget)parent, identifier.getPossibleChildNames());
        EffectiveAugmentationSchema resolvedSchema = new EffectiveAugmentationSchema(schema, (DataNodeContainer)parent);
        this.schemaStack.push((DocumentedNode.WithStatus)resolvedSchema);
        return resolvedSchema;
    }

    private static @NonNull AugmentationSchemaNode findSchemaForAugment(AugmentationTarget schema, Set<QName> qnames) {
        for (AugmentationSchemaNode augment : schema.getAvailableAugmentations()) {
            if (!qnames.equals(augment.getChildNodes().stream().map(SchemaNode::getQName).collect(Collectors.toUnmodifiableSet()))) continue;
            return augment;
        }
        throw new IllegalStateException("Unknown augmentation node detected, identified by: " + qnames + ", in: " + schema);
    }

    private static SchemaNode findCaseByChild(ChoiceSchemaNode parent, QName qname) {
        for (CaseSchemaNode caze : parent.getCases()) {
            if (caze.dataChildByName(qname) == null) continue;
            return caze;
        }
        return null;
    }
}

